export default function StatusBadge({ value }: { value: string }) {
  const cls =
    value === "pending"
      ? "bg-amber-100 border-amber-300"
      : value === "approved" || value === "completed"
      ? "bg-emerald-100 border-emerald-300"
      : value === "denied" || value === "cancelled"
      ? "bg-red-100 border-red-300"
      : "bg-gray-100 border-gray-300";
  return (
    <span className={`text-xs px-2 py-1 rounded border ${cls}`}>{value}</span>
  );
}
