"use client";
import React, { useEffect, useState } from "react";
import ApiCall from "@/api/api-calls";

export default function ReviewCategoryConflicts({ batchId }) {
  const [items, setItems] = useState([]);
  const [statusFilter, setStatusFilter] = useState("conflict");

  const fetchData = async () => {
    const { data } = await ApiCall.staging.getCategoryStaging({
      batchId,
      conflictStatus: statusFilter,
    });
    setItems(data.items || []);
  };

  useEffect(() => {
    fetchData();
  }, [batchId, statusFilter]);

  const handleApprove = async (id) => {
    await ApiCall.staging.approveCategory(id);
    fetchData();
  };

  const handleDiscard = async (id) => {
    await ApiCall.staging.discardCategory(id);
    fetchData();
  };

  const getReadable = (val, field) => {
    if (val == null)
      return <span className="italic text-gray-400">(nincs)</span>;

    if (typeof val === "string" || typeof val === "number") {
      return <span>{val}</span>;
    }

    if (Array.isArray(val)) {
      if (field === "childCategory") {
        return (
          <ul className="list-disc list-inside text-xs text-gray-700">
            {val.map((cat, idx) => (
              <li key={idx}>{typeof cat === "object" ? cat.title : cat}</li>
            ))}
          </ul>
        );
      }

      if (field === "productCategoryImage") {
        return (
          <ul className="list-disc list-inside text-xs text-gray-600">
            {val.map((img, idx) => (
              <li key={idx}>{typeof img === "object" ? img.title : img}</li>
            ))}
          </ul>
        );
      }

      return (
        <pre className="whitespace-pre-wrap text-xs text-gray-600">
          {JSON.stringify(val, null, 2)}
        </pre>
      );
    }

    if (typeof val === "object") {
      return (
        <pre className="whitespace-pre-wrap text-xs text-gray-600">
          {JSON.stringify(val, null, 2)}
        </pre>
      );
    }

    return val.toString();
  };

  return (
    <div className="p-4">
      <h2 className="text-xl font-bold mb-4">📁 Review Category Conflicts</h2>

      <div className="flex gap-4 mb-4">
        <select
          value={statusFilter}
          onChange={(e) => setStatusFilter(e.target.value)}
          className="border px-2 py-1">
          <option value="">All</option>
          <option value="conflict">Conflict</option>
          <option value="new">New</option>
          <option value="update">Update</option>
        </select>
      </div>

      <table className="w-full table-auto border text-sm">
        <thead>
          <tr className="bg-gray-100 text-left">
            <th className="p-2 border">Category</th>
            <th className="p-2 border">Field</th>
            <th className="p-2 border">Live</th>
            <th className="p-2 border">Staging</th>
            <th className="p-2 border">Actions</th>
          </tr>
        </thead>
        <tbody>
          {items.map((item) => {
            const conflicts = item.conflictFields || [];

            return conflicts.map((field, idx) => {
              const diff = item.conflictMeta?.differences?.[field];
              const live = diff?.live;
              const staging =
                diff?.staging ?? item[field]?.value ?? item[field];

              return (
                <tr
                  key={`${item._id}-${field}-${idx}`}
                  className="border-b align-top">
                  {idx === 0 && (
                    <td
                      rowSpan={conflicts.length}
                      className="p-2 border font-medium text-gray-800">
                      {item.productCategoryTitle?.value || "(nincs)"}
                    </td>
                  )}

                  <td className="p-2 border text-red-600 font-medium">
                    {field}
                  </td>

                  <td className="p-2 border bg-red-50">
                    {getReadable(live, field)}
                  </td>
                  <td className="p-2 border bg-blue-50">
                    {getReadable(staging, field)}
                  </td>

                  {idx === 0 && (
                    <td
                      rowSpan={conflicts.length}
                      className="p-2 border space-y-2">
                      <button
                        onClick={() => handleApprove(item._id)}
                        className="bg-green-500 text-white px-3 py-1 rounded w-full">
                        ✅ Approve
                      </button>
                      <button
                        onClick={() => handleDiscard(item._id)}
                        className="bg-red-500 text-white px-3 py-1 rounded w-full">
                        🗑️ Discard
                      </button>
                    </td>
                  )}
                </tr>
              );
            });
          })}
        </tbody>
      </table>
    </div>
  );
}

// "use client";
// import React, { useEffect, useState } from "react";
// import ApiCall from "@/api/api-calls";

// export default function ReviewCategoryConflicts({ batchId }) {
//   const [items, setItems] = useState([]);
//   const [statusFilter, setStatusFilter] = useState("conflict");

//   const fetchData = async () => {
//     const { data } = await ApiCall.staging.getCategoryStaging({
//       batchId,
//       conflictStatus: statusFilter,
//     });
//     setItems(data.items || []);
//   };

//   useEffect(() => {
//     fetchData();
//   }, [batchId, statusFilter]);

//   const handleApprove = async (id) => {
//     await ApiCall.staging.approveCategory(id);
//     fetchData();
//   };

//   const handleDiscard = async (id) => {
//     await ApiCall.staging.discardCategory(id);
//     fetchData();
//   };

//   const getReadable = (val) => {
//     if (val == null) return "(nincs)";
//     if (typeof val === "string" || typeof val === "number") return val;
//     if (Array.isArray(val)) return JSON.stringify(val, null, 2);
//     if (typeof val === "object") return JSON.stringify(val, null, 2);
//     return val.toString();
//   };

//   return (
//     <div className="p-4">
//       <h2 className="text-xl font-bold mb-4">📁 Review Category Conflicts</h2>

//       <div className="flex gap-4 mb-4">
//         <select
//           value={statusFilter}
//           onChange={(e) => setStatusFilter(e.target.value)}
//           className="border px-2 py-1">
//           <option value="">All</option>
//           <option value="conflict">Conflict</option>
//           <option value="new">New</option>
//           <option value="update">Update</option>
//         </select>
//       </div>

//       <table className="w-full table-auto border text-sm">
//         <thead>
//           <tr className="bg-gray-100">
//             <th className="p-2 border">Category</th>
//             <th className="p-2 border">Field</th>
//             <th className="p-2 border">Live</th>
//             <th className="p-2 border">Staging</th>
//             <th className="p-2 border">Actions</th>
//           </tr>
//         </thead>
//         <tbody>
//           {items.map((item) => {
//             const conflicts = item.conflictFields || [];

//             return conflicts.map((field, idx) => {
//               const diff = item.conflictMeta?.differences?.[field];
//               const live = diff?.live;
//               const staging = diff?.staging;

//               return (
//                 <tr key={`${item._id}-${field}-${idx}`} className="border-b">
//                   {idx === 0 && (
//                     <td
//                       rowSpan={conflicts.length}
//                       className="p-2 border font-medium text-gray-800 align-top">
//                       {item.productCategoryTitle?.value || "(nincs)"}
//                     </td>
//                   )}
//                   <td className="p-2 border text-red-600">{field}</td>
//                   <td className="p-2 border text-gray-500 whitespace-pre-wrap">
//                     {getReadable(live)}
//                   </td>
//                   <td className="p-2 border text-blue-600 whitespace-pre-wrap">
//                     {getReadable(staging ?? item[field]?.value ?? item[field])}
//                   </td>
//                   {idx === 0 && (
//                     <td
//                       rowSpan={conflicts.length}
//                       className="p-2 border align-top space-y-2">
//                       <button
//                         onClick={() => handleApprove(item._id)}
//                         className="bg-green-500 text-white px-3 py-1 rounded w-full">
//                         ✅ Approve
//                       </button>
//                       <button
//                         onClick={() => handleDiscard(item._id)}
//                         className="bg-red-500 text-white px-3 py-1 rounded w-full">
//                         🗑️ Discard
//                       </button>
//                     </td>
//                   )}
//                 </tr>
//               );
//             });
//           })}
//         </tbody>
//       </table>
//     </div>
//   );
// }
