// ProductGroupTabs.jsx
import React from "react";

const ProductGroupTabs = ({ activeTab, onTabChange, productCnt }) => {
  return (
    <div className="flex w-full border-b mb-4">
      <button
        onClick={() => onTabChange(1)}
        className={`px-4 py-2 border-t border-l ${
          activeTab === 1 ? "bg-green-500 text-white" : ""
        }`}>
        Termék csoport
      </button>
      <button
        onClick={() => onTabChange(2)}
        className={`px-4 py-2 border-t border-l ${
          activeTab === 2 ? "bg-green-500 text-white" : ""
        }`}>
        Terméklista ({productCnt})
      </button>
      <button
        onClick={() => onTabChange(3)}
        className={`px-4 py-2 border-t border-l ${
          activeTab === 3 ? "bg-green-500 text-white" : ""
        }`}>
        Termék csoport verziók
      </button>
    </div>
  );
};

export default ProductGroupTabs;
