"use client";
import FileUploader from "@/components/media-store/FileUploader/FileUploader";
import ApiCall from "@/api/api-calls";
import toast from "react-hot-toast";

const UploadPanel = ({ onUploadSuccess }) => {
  const handleUpload = async (formData, onProgress) => {
    try {
      const res = await ApiCall.mediaStore.upload(formData, onProgress);
      if (res.status === 200 || res.status === 201) {
        toast.success("Files uploaded successfully");
        onUploadSuccess?.();
      } else {
        throw new Error(res?.data?.message || "Upload failed");
      }
    } catch (err) {
      toast.error("Upload failed: " + err.message);
      throw err;
    }
  };

  return (
    <div className="w-3xl mx-auto">
      <h3 className="text-xl font-semibold mb-4">Fájlok feltöltése</h3>
      <FileUploader
        onUpload={handleUpload}
        onUploadSuccess={onUploadSuccess}
        acceptedTypes="image/*,application/pdf,.docx,.xlsx"
      />
    </div>
  );
};

export default UploadPanel;
