// components/Media/MediaGalleryModal.jsx
"use client";
import { Dialog, DialogPanel } from "@headlessui/react";
import { X } from "lucide-react";
import MediaGallery from "@/components/media-store/MediaGallery";

const MediaGalleryModal = ({
  isOpen,
  onClose,
  action = "productGallery",
  onConfirmSelection,
}) => {
  if (!isOpen) return null;

  return (
    <Dialog open={isOpen} onClose={onClose} className="fixed inset-0 z-50">
      <div className="fixed inset-0 bg-black/50" />
      <div className="fixed inset-0 flex items-center justify-center p-4">
        <DialogPanel className="w-full max-w-7xl max-h-[90vh] bg-white rounded-xl overflow-y-auto shadow-lg relative">
          {/* Close Button */}
          <button
            onClick={onClose}
            className="absolute top-4 right-4 text-gray-500 hover:text-black">
            <X />
          </button>

          <div className="p-6">
            {/* Just pass props — MediaGallery handles everything */}
            <MediaGallery
              mode="picker"
              action={action}
              onConfirmSelection={(selectedImage) => {
                onConfirmSelection?.(selectedImage);
                onClose();
              }}
              onClose={onClose}
            />
          </div>
        </DialogPanel>
      </div>
    </Dialog>
  );
};

export default MediaGalleryModal;
