// components/ChatUnreadBadge.jsx
"use client";

import { useContext } from "react";
import { ChatUnreadContext } from "@/context/SocketProvider";
import { MessageSquareDot } from "lucide-react";

export default function ChatUnreadBadge() {
  const { unread } = useContext(ChatUnreadContext);

  if (!unread) return null;

  return (
    <button
      type="button"
      className="relative inline-flex items-center justify-center p-1 rounded-full hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-emerald-500"
      title="Olvasatlan chat üzenetek">
      <MessageSquareDot className="w-5 h-5 text-gray-600" />
      {unread > 0 && (
        <span className="absolute -top-1 -right-1 inline-flex items-center justify-center px-1.5 py-0.5 rounded-full bg-red-500 text-[10px] font-semibold text-white">
          {unread > 9 ? "9+" : unread}
        </span>
      )}
    </button>
  );
}
