import React, { useEffect, useState } from "react";
import ApiCall from "@/api/api-calls";
import { toast } from "react-hot-toast";
import ExpandedRowTabs from "./ExpandedRowTabs";
import InventoryElement from "./InventoryElement";
import InventoryInsurance from "./InventoryInsurance";
import InventoryInvoice from "./InventoryInvoice";
import InventoryRegDocument from "./InventoryRegDocument";
import InventoryReport from "./InventoryReport";
import InventoryLeaseDoc from "./InventoryLeaseDoc";
import InventoryMovements from "./InventoryMovements";

const ExpandedRow = ({ id, onRowUpdated }) => {
  const [data, setData] = useState(null);
  const [activeTab, setActiveTab] = useState(1);
  const [loading, setLoading] = useState(false);

  useEffect(() => {
    setLoading(true);
    if (!id) return;
    const fetchRow = async () => {
      try {
        const rowElement = await ApiCall.inventory.getOne(id);
        if (rowElement.status === 200) {
          setData(rowElement.data);
          toast.success("Leltár sor sikeresen betöltve");
        }
      } catch (error) {
        console.error("Error fetching row data:", error);
        toast.error("Hiba a sor betöltésekor: " + error.message);
      } finally {
        setLoading(false);
      }
    };
    fetchRow();
  }, [id]);
  console.log("data", data);

  return (
    <div
      className="w-full px-2 py-2"
      style={{ overflow: "auto hidden", maxWidth: "85vw" }}>
      <ExpandedRowTabs activeTab={activeTab} onTabChange={setActiveTab} />
      {activeTab === 1 && data && (
        <div className="w-full px-3 md:px-4">
          <InventoryElement
            asset={data.asset}
            references={data.references}
            onRowUpdated={onRowUpdated}
          />
        </div>
      )}
      {activeTab === 2 && data && (
        <InventoryRegDocument
          asset={data.asset}
          references={data.references}
          onRowUpdated={onRowUpdated}
          assetId={data.asset.id}
          documentTypeId={
            data?.references.document_types.find((dt) => dt.name === "törzslap")
              ?.id
          }
        />
      )}
      {activeTab === 3 && data && (
        <InventoryInvoice
          asset={data.asset}
          references={data.references}
          onRowUpdated={onRowUpdated}
          assetId={data.asset.id}
          documentTypeId={
            data?.references.document_types.find((dt) => dt.name === "invoice")
              ?.id
          }
        />
      )}
      {activeTab === 4 && data && (
        <InventoryInsurance
          asset={data.asset}
          references={data.references}
          onRowUpdated={onRowUpdated}
          assetId={data.asset.id}
          documentTypeId={
            data?.references.document_types.find(
              (dt) => dt.name === "biztosítási-dokumentumok"
            )?.id
          }
        />
      )}
      {activeTab === 5 && data && (
        <InventoryReport
          asset={data.asset}
          references={data.references}
          onRowUpdated={onRowUpdated}
          assetId={data.asset.id}
          documentTypeId={
            data?.references.document_types.find(
              (dt) => dt.name === "jegyzőkönyv"
            )?.id
          }
        />
      )}
      {activeTab === 6 && data && (
        <InventoryLeaseDoc
          asset={data.asset}
          references={data.references}
          onRowUpdated={onRowUpdated}
          assetId={data.asset.id}
        />
      )}
      {activeTab === 7 && data && (
        <InventoryMovements
          asset={data.asset}
          references={data.references}
          onRowUpdated={onRowUpdated}
          assetId={data.asset.id}
        />
      )}
    </div>
  );
};

export default ExpandedRow;
