"use client";
import { useEffect, useState } from "react";
import Select from "react-select";
import Input from "@/components/shared/input/Input";
import { useForm } from "@/hooks/custom-form-hook";
import toast from "react-hot-toast";
import ApiCall from "@/api/api-calls";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";

const FilingEditProperties = ({
  filingId,
  ownCompanies,
  partnerCompanies,
  currencies,
}) => {
  const [formState, handleInput, setFormData] = useForm({}, true);
  const [ownCompanySelected, setOwnCompanySelected] = useState(null);
  const [partnerCompanySelected, setPartnerCompanySelected] = useState(null);
  const [selectedCurrency, setSelectedCurrency] = useState(null);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    if (!currencies.length || !ownCompanies.length || !partnerCompanies.length)
      return;

    const loadFiling = async () => {
      try {
        const res = await ApiCall.filing.getOne(filingId);
        if (res.status === 200) {
          const f = res.data.filing;

          setOwnCompanySelected(
            ownCompanies.find((c) => c.value === f.own_company_id) || null
          );
          setPartnerCompanySelected(
            partnerCompanies.find((c) => c.value === f.partner_company_id) ||
              null
          );
          const defaultCurrency =
            currencies.find((c) => c.label === "HUF") || currencies[0] || null;

          setSelectedCurrency(
            currencies.find((c) => c.value === f.currency_id) || defaultCurrency
          );

          setFormData(
            {
              document_arrived_at: {
                value: f.document_arrived_at?.split("T")[0] || "",
                isValid: true,
              },
              invoice_serial_number: {
                value: f.invoice_serial_number || "",
                isValid: true,
              },
              document_registration_number: {
                value: f.document_registration_number || "",
                isValid: true,
              },
              payment_deadline: {
                value: f.payment_deadline?.split("T")[0] || "",
                isValid: true,
              },
              invoice_value: { value: f.invoice_value || "", isValid: true },
            },
            true
          );
        }
      } catch {
        toast.error("Nem sikerült betölteni a bejegyzést");
      } finally {
        setLoading(false);
      }
    };

    loadFiling();
  }, [filingId, currencies, ownCompanies, partnerCompanies, setFormData]);

  //   useEffect(() => {
  //     const loadFiling = async () => {
  //       try {
  //         const res = await ApiCall.filing.getOne(filingId);
  //         if (res.status === 200) {
  //           const f = res.data.filing;
  //           console.log("Currency ID from filing:", f.currency_id);
  //           console.log("Currencies list:", currencies);
  //           setOwnCompanySelected(
  //             ownCompanies.find((c) => c.value === f.own_company_id)
  //           );
  //           setPartnerCompanySelected(
  //             partnerCompanies.find((c) => c.value === f.partner_company_id)
  //           );
  //           setSelectedCurrency(
  //             currencies.find((c) => c.value === f.currency_id)
  //           );

  //           setFormData(
  //             {
  //               document_arrived_at: {
  //                 value: f.document_arrived_at?.split("T")[0] || "",
  //                 isValid: true,
  //               },
  //               invoice_serial_number: {
  //                 value: f.invoice_serial_number || "",
  //                 isValid: true,
  //               },
  //               document_registration_number: {
  //                 value: f.document_registration_number || "",
  //                 isValid: true,
  //               },
  //               payment_deadline: {
  //                 value: f.payment_deadline?.split("T")[0] || "",
  //                 isValid: true,
  //               },
  //               invoice_value: { value: f.invoice_value || "", isValid: true },
  //             },
  //             true
  //           );
  //         }
  //       } catch {
  //         toast.error("Nem sikerült betölteni a bejegyzést");
  //       } finally {
  //         setLoading(false);
  //       }
  //     };
  //     loadFiling();
  //   }, [filingId, ownCompanies, partnerCompanies, currencies, setFormData]);

  const handleSubmit = async () => {
    try {
      const payload = {
        ...Object.fromEntries(
          Object.entries(formState.inputs).map(([k, v]) => [k, v.value])
        ),
        own_company_id: ownCompanySelected?.value,
        partner_company_id: partnerCompanySelected?.value,
        currency_id: selectedCurrency?.value,
      };

      const res = await ApiCall.filing.postUpsert(filingId, payload);
      if (res.status === 200) toast.success(res.data.message || "Frissítve");
      else toast.error(res.data.error || "Mentés sikertelen");
    } catch {
      toast.error("Mentés sikertelen");
    }
  };
  if (loading) return <p className="text-gray-500">Betöltés...</p>;
  return (
    <>
      {formState && formState?.inputs && (
        <div>
          <LabeledInput label="Saját cég:" description="Válassz saját céget.">
            <Select
              options={ownCompanies}
              className="w-full"
              menuPosition={"fixed"}
              placeholder="Válassz saját céget"
              backspaceRemovesValue={false}
              value={ownCompanySelected}
              onChange={(selected) => setOwnCompanySelected(selected)}
            />
          </LabeledInput>
          <LabeledInput
            label="Partner cég:"
            description="Válassz partner céget.">
            <Select
              options={partnerCompanies}
              placeholder="Válassz partner céget"
              value={partnerCompanySelected}
              onChange={(selected) => setPartnerCompanySelected(selected)}
            />
          </LabeledInput>
          <LabeledInput label="Dokumentum beérkezett:">
            <Input
              element="input"
              id="document_arrived_at"
              name="document_arrived_at"
              type="date"
              onInput={handleInput}
              value={formState.inputs.document_arrived_at?.value}
              initialValid={true}
            />
          </LabeledInput>
          <LabeledInput label="Számla sorszám:">
            <Input
              element="input"
              id="invoice_serial_number"
              type="text"
              name="invoice_serial_number"
              onInput={handleInput}
              value={formState.inputs.invoice_serial_number?.value}
              initialValid={true}
            />
          </LabeledInput>
          <LabeledInput label="Iktatószám:">
            <Input
              element="input"
              id="document_registration_number"
              type="text"
              name="document_registration_number"
              onInput={handleInput}
              value={formState.inputs.document_registration_number?.value}
              readOnly
              initialValid={true}
            />
          </LabeledInput>
          <LabeledInput label="Fizetési határidő:">
            <Input
              element="input"
              id="payment_deadline"
              type="date"
              name="payment_deadline"
              onInput={handleInput}
              value={formState.inputs.payment_deadline?.value}
              initialValid={true}
            />
          </LabeledInput>
          <LabeledInput label="Pénznem:">
            <Select
              options={currencies}
              placeholder="Pénznem"
              value={selectedCurrency}
              onChange={(selected) => setSelectedCurrency(selected)}
            />
          </LabeledInput>
          <LabeledInput label="Számla érték:">
            <Input
              element="input"
              id="invoice_value"
              name="invoice_value"
              type="number"
              onInput={handleInput}
              value={parseFloat(formState.inputs.invoice_value?.value)}
              initialValid={true}
            />
          </LabeledInput>

          <button
            className="bg-blue-600 text-white px-4 py-2 mt-4 rounded"
            onClick={handleSubmit}>
            Mentés
          </button>
        </div>
      )}
    </>
  );
};

export default FilingEditProperties;
