"use client";

import { useEffect, useState } from "react";
import toast from "react-hot-toast";
import ApiCall from "@/api/api-calls";

import ExpandedRowTabs from "@/components/filing/ExpandedRowTabs";
import FilingEditProperties from "./FilingEditProperties";
import FilingDocumentTab from "@/components/filing/FilingDocumentTab";

const ExpandedRow = ({ filingId, onRowUpdated }) => {
  const [activeTab, setActiveTab] = useState(1);
  const [ownCompanies, setOwnCompanies] = useState([]);
  const [partnerCompanies, setPartnerCompanies] = useState([]);
  const [currencies, setCurrencies] = useState([]);
  const [documentTypes, setDocumentTypes] = useState([]);

  useEffect(() => {
    const fetchInitialData = async () => {
      try {
        const [filing, curr, types] = await Promise.all([
          ApiCall.filing.getOne(filingId),
          ApiCall.currency.getAll(),
          ApiCall.documents.getDocumentTypes(),
        ]);

        if (curr.status === 200) setCurrencies(curr.data.currencies);
        if (filing.status === 200) {
          setOwnCompanies(filing.data.references.ownCompanies || []);
          setPartnerCompanies(filing.data.references.partnerCompanies || []);
        }
        if (types.status === 200) setDocumentTypes(types.data);
      } catch {
        toast.error("Hiba az adatok betöltésekor");
      }
    };
    fetchInitialData();
  }, [filingId]);

  const getDocTypeId = (typeValue) =>
    documentTypes.find((dt) => dt.value === typeValue)?.id || null;

  return (
    <div className="p-6 max-w-4xl mx-auto">
      <ExpandedRowTabs activeTab={activeTab} onTabChange={setActiveTab} />

      <div className={activeTab === 1 ? "block" : "hidden"}>
        <FilingEditProperties
          filingId={filingId}
          ownCompanies={ownCompanies}
          partnerCompanies={partnerCompanies}
          currencies={currencies}
        />
      </div>

      <div className={activeTab === 2 ? "block" : "hidden"}>
        <FilingDocumentTab
          filingId={filingId}
          description="Díjbekérő"
          tabLabel="Díjbekérők"
          documentTypeIds={[
            getDocTypeId("díjbekérő"),
            getDocTypeId("előlegszámla"),
          ].filter(Boolean)}
          defaultDocumentTypeId={getDocTypeId("díjbekérő")}
        />
      </div>

      <div className={activeTab === 3 ? "block" : "hidden"}>
        <FilingDocumentTab
          filingId={filingId}
          description="Számla"
          tabLabel="Számlák"
          documentTypeIds={[getDocTypeId("invoice")].filter(Boolean)}
          defaultDocumentTypeId={getDocTypeId("invoice")}
        />
      </div>

      <div className={activeTab === 4 ? "block" : "hidden"}>
        <FilingDocumentTab
          filingId={filingId}
          description="Végszámla"
          tabLabel="Végszámla"
          documentTypeIds={[getDocTypeId("végszámla")].filter(Boolean)}
          defaultDocumentTypeId={getDocTypeId("végszámla")}
        />
      </div>
    </div>
  );
};

export default ExpandedRow;

// "use client";

// import { useEffect, useState } from "react";
// import toast from "react-hot-toast";
// import ApiCall from "@/api/api-calls";

// import ExpandedRowTabs from "@/components/filing/ExpandedRowTabs";
// import FilingEditProperties from "./FilingEditProperties";
// import FilingDocumentTab from "@/components/filing/FilingDocumentTab";

// const ExpandedRow = ({ filingId, onRowUpdated }) => {
//   const [activeTab, setActiveTab] = useState(1);
//   const [ownCompanies, setOwnCompanies] = useState([]);
//   const [partnerCompanies, setPartnerCompanies] = useState([]);
//   const [currencies, setCurrencies] = useState([]);
//   const [documentTypes, setDocumentTypes] = useState([]);

//   useEffect(() => {
//     const fetchInitialData = async () => {
//       try {
//         const [filing, curr, types] = await Promise.all([
//           ApiCall.filing.getOne(filingId),
//           ApiCall.currency.getAll(),
//           ApiCall.documents.getDocumentTypes(),
//         ]);

//         if (curr.status === 200) setCurrencies(curr.data.currencies);
//         if (filing.status === 200) {
//           setOwnCompanies(filing.data.references.ownCompanies || []);
//           setPartnerCompanies(filing.data.references.partnerCompanies || []);
//         }
//         if (types.status === 200) setDocumentTypes(types.data);
//       } catch {
//         toast.error("Hiba az adatok betöltésekor");
//       }
//     };
//     fetchInitialData();
//   }, [filingId]);

//   const getDocTypeId = (typeValue) =>
//     documentTypes.find((dt) => dt.value === typeValue)?.id || null;

//   return (
//     <div className="p-6 max-w-4xl mx-auto">
//       <ExpandedRowTabs activeTab={activeTab} onTabChange={setActiveTab} />
//       <div className={activeTab === 1 ? "block" : "hidden"}>
//         <FilingEditProperties
//           filingId={filingId}
//           ownCompanies={ownCompanies}
//           partnerCompanies={partnerCompanies}
//           currencies={currencies}
//         />
//       </div>
//       <div className={activeTab === 2 ? "block" : "hidden"}>
//         <FilingDocumentTab
//           filingId={filingId}
//           description="Díjbekérő"
//           tabLabel="Díjbekérők"
//           documentTypeIds={[
//             getDocTypeId("díjbekérő"),
//             getDocTypeId("előlegszámla"),
//           ].filter(Boolean)}
//         />
//       </div>

//       <div className={activeTab === 3 ? "block" : "hidden"}>
//         <FilingDocumentTab
//           filingId={filingId}
//           description="Számla"
//           tabLabel="Számlák"
//           documentTypeIds={[getDocTypeId("invoice")].filter(Boolean)}
//         />
//       </div>

//       <div className={activeTab === 4 ? "block" : "hidden"}>
//         <FilingDocumentTab
//           filingId={filingId}
//           description="Végszámla"
//           tabLabel="Végszámla"
//           documentTypeIds={[getDocTypeId("végszámla")].filter(Boolean)}
//         />
//       </div>
//     </div>
//   );
// };

// export default ExpandedRow;
