"use client";
import { useMemo } from "react";
import useDynamicManager from "@/store/managers/useDynamicManager";

const steps = [
  {
    label: "🚀 Termék táblázat feltöltés megkezdve",
    match: "Termék táblázat feltöltés megkezdve",
  },
  {
    label: "✅ Fejlécek ellenőrzése befejeződött.",
    match: "Fejlécek ellenőrzése befejeződött.",
  },
  {
    label: "✅ Termék csoportok, termékek, kategóriák kigyűjtése befejeződött.",
    match: "Termék csoportok, termékek, kategóriák kigyűjtése befejeződött.",
  },
  {
    label: "✅ Kategóriák feldolgozása befejeződött.",
    match: "Kategóriák feldolgozása befejeződött.",
  },
  {
    label: "✅ Termékcsoportok feldolgozása befejeződött",
    match: "Termékcsoportok feldolgozása befejeződött",
  },

  { label: "✅ Feltöltés befejeződött", match: "Feltöltés befejeződött" },
];

const UploadProgressSteps = () => {
  const { state } = useDynamicManager("uploadLog");

  const completedSteps = useMemo(() => {
    const logs = state?.logs ?? [];

    return steps.map(({ label, match }) => ({
      label,
      done: logs.some((log) => log.text.includes(match)),
    }));
  }, [state?.logs]);

  return (
    <div className="bg-white border rounded-lg shadow p-4 mb-4">
      <h3 className="font-bold mb-2">Feltöltés állapota</h3>
      <ul className="space-y-1 text-sm">
        {completedSteps.map((step, idx) => (
          <li key={idx} className="flex items-center gap-2">
            <span>{step.done ? "✅" : "⏳"}</span>
            <span className={step.done ? "text-green-600" : "text-gray-500"}>
              {step.label}
            </span>
          </li>
        ))}
      </ul>
    </div>
  );
};

export default UploadProgressSteps;
