"use client";
import { useMemo, useState, useEffect, useRef } from "react";
import useDynamicManager from "@/store/managers/useDynamicManager";

const steps = [
  {
    label: "Termék táblázat feltöltés megkezdve",
    pattern: /.*🚀 Termék táblázat feltöltés megkezdve/i,
  },
  {
    label: "Fejlécek ellenőrzése befejeződött.",
    pattern: /.*Fejlécek ellenőrzése befejeződött./,
  },
  {
    label: "Termék csoportok, termékek, kategóriák kigyűjtése befejeződött.",
    pattern:
      /.*Termék csoportok, termékek, kategóriák kigyűjtése befejeződött./,
  },
  {
    label: "Kategóriák feldolgozása befejeződött.",
    pattern: /.*Kategóriák feldolgozása befejeződött./,
  },
  {
    label: "Termékcsoportok feldolgozása befejeződött",
    pattern: /.*Termékcsoportok feldolgozása befejeződött/,
  },

  {
    label: "Feltöltés befejeződött",
    pattern: /.*Feltöltés.*befejeződött/,
  },
];
const UploadProgressBar = () => {
  const { state } = useDynamicManager("uploadLog");
  const [secondsPassed, setSecondsPassed] = useState(0);
  const intervalRef = useRef(null);

  const completedCount = useMemo(() => {
    return steps.filter(({ pattern }) =>
      state?.logs?.some((log) => pattern.test(log.text))
    ).length;
  }, [state?.logs]);

  const percentage = Math.round((completedCount / steps.length) * 100);

  // ⏱ Detect when upload starts
  const hasUploadStarted = useMemo(() => {
    return state?.logs?.some((log) =>
      /🚀 Starting product upload/i.test(log.text)
    );
  }, [state?.logs]);

  useEffect(() => {
    // ✅ Start timer when upload starts (but only once)
    if (hasUploadStarted && !intervalRef.current && percentage < 100) {
      intervalRef.current = setInterval(() => {
        setSecondsPassed((prev) => prev + 1);
      }, 1000);
    }

    // 🛑 Stop timer when upload finishes
    if (percentage === 100 && intervalRef.current) {
      clearInterval(intervalRef.current);
      intervalRef.current = null;
    }

    return () => {
      if (intervalRef.current) {
        clearInterval(intervalRef.current);
        intervalRef.current = null;
      }
    };
  }, [hasUploadStarted, percentage]);

  const formatTime = (seconds) => {
    const mins = Math.floor(seconds / 60);
    const secs = seconds % 60;
    return `${mins}:${secs.toString().padStart(2, "0")}`;
  };

  return (
    <div className="w-full mb-4">
      <div className="bg-gray-300 h-4 rounded-full overflow-hidden shadow-inner">
        <div
          className="bg-green-500 h-full transition-all duration-500 ease-out"
          style={{ width: `${percentage}%` }}
        />
      </div>
      <div className="text-xs text-gray-600 mt-1 flex justify-between">
        <span>{percentage}% kész</span>
        {hasUploadStarted && <span>⏱️ {formatTime(secondsPassed)}</span>}
      </div>
    </div>
  );
};

export default UploadProgressBar;
