import { useContext } from "react";
import { SocketStatusContext } from "@/context/SocketProvider";

const SocketStatusBanner = () => {
  const status = useContext(SocketStatusContext);

  let color = "gray";
  if (status === "connected") color = "green";
  else if (status === "error") color = "red";
  else if (status === "disconnected") color = "yellow";
  console.log("status", status);
  return (
    <div
      className={`text-xs px-2 py-1 bg-${color}-100 text-${color}-700 rounded`}>
      Websocket státusza: {status}
    </div>
  );
};

export default SocketStatusBanner;
