"use client";
import React, { useCallback, useEffect, useState } from "react";
import ApiCall from "@/api/api-calls";
import toast, { ToastBar } from "react-hot-toast";
import useDynamicManager from "@/store/managers/useDynamicManager";
import Modal from "@/components/shared/modal/Modal";
import { initialData } from "@/data/data";
import icons from "@/assets/icons/icons";
import { useModalManager } from "@/hooks/useModalManager";
import Button from "@/components/shared/button/Button";
import PageEditorFormFields from "../page-box/PageEditorFormFields";
import { useForm } from "@/hooks/custom-form-hook";
import Container from "@/components/editor/container/Container";
import useContainerActions from "@/hooks/useContainerActions";
import { useParams } from "next/navigation";
import Select from "react-select";
import { useRouter } from "next/navigation";

const EditPageEditor = () => {
  const [pageEditorData, setPageEditorData] = useState(null);
  const [pagesList, setPagesList] = useState(null);
  const [boxColumns, setBoxColumns] = useState(null);
  const [formState, handleInput, handleSetInputData] = useForm([], false);
  const { toggleModal, isModalOpen } = useModalManager();
  const router = useRouter();

  const {
    state,
    setContainerList,
    setPublishedPage,
    setHasParentPage,
    setShowPageInMenu,
    setSelectedParentPage,
    setCurrentChildPages,
    loadPageEditorInitialData,
    ...rest
  } = useDynamicManager("pageEditor");
  const { handleAddContainer } = useContainerActions(
    initialData,
    toggleModal,
    "pageEditor"
  );
  const params = useParams();

  useEffect(() => {
    const fetchPageEditorData = async () => {
      const response = await ApiCall.pageEditor.getUpdatePageEditor(params.id);

      if (response.status === 200) {
        setPageEditorData(response?.data?.body?.data);
        setPagesList(response?.data?.body?.pagesList);
        loadPageEditorInitialData({ data: response?.data?.body });

        toast.success("Oldaleszerkesztő adatok betöltve.");
      } else {
        toast.error("Oldalszerkesző adatok betöltése sikertelen.");
      }
    };
    fetchPageEditorData();
  }, []);

  useEffect(() => {
    if (pageEditorData) {
      setContainerList({ data: pageEditorData.pageContent });
    }
  }, [pageEditorData]);

  useEffect(() => {
    const fetchBoxColumnsData = async () => {
      const response = await ApiCall.boxColumns.getAll();
      if (response.status === 200) {
        setBoxColumns(response?.data?.columnList);
        toast.success("Oszlop adatok betöltve.");
      } else {
        toast.error("Oszlop adatok betöltése sikertelen.");
      }
    };
    fetchBoxColumnsData();
  }, []);

  const renderContainers = useCallback(() => {
    return state?.containerData?.map((c, idx) => {
      return (
        <Container
          key={idx}
          data={c}
          alldata={state?.containerData}
          parent={idx}
          handleTitleChange={rest.setContainerTitle}
          type={"pageEditor"}
        />
      );
    });
  }, [state, rest]);

  const handlePageEditorUpdate = useCallback(() => {
    const sendData = async () => {
      const ret = {
        inputs: formState.inputs,
        boxes: state.containerData,
        isPublished: state?.isPublishedPage,
        showInMenu: state?.showPageInMenu,
        hasParent: state?.hasParentPage,
        parent: state?.selectedParentPage,
      };
      const response = await ApiCall.pageEditor.postUpdatePageEditor(
        params.id,
        ret
      );
      if (response.status === 200) {
        toast.success(response.data.message || "Sikeresen frissítve!");
        // router.push("/admin/page-editor/list");
      } else {
        toast.error(response.error || "Sikertelen frissítés!");
      }
    };
    sendData();
  }, [state, formState, params]);

  return (
    <div className="w-full grid grid-cols-1 md:grid-cols-6">
      <div className="w-full col-span-5">
        {" "}
        {pageEditorData && (
          <PageEditorFormFields
            data={pageEditorData}
            handleInput={handleInput}
            initialValid={true}
          />
        )}
        <Button
          className="w-full flex flex-row flex-nowrap justify-center items-center cursor-pointer border border-gray-600/50 text-white hover:bg-green-600 hover:text-white bg-gray-600 py-2 px-4 font-bold my-4"
          onClick={() => toggleModal("containerModal")}
          btntext="Konténer hozzáadása"
          icon={icons.add}
          iconclass="flex w-[1.5rem] h-[1.5rem] fill-white stroke-white ml-4"></Button>
        {renderContainers()}
        <Button
          btntext="Mentés"
          disabled={!formState.isValid}
          onClick={handlePageEditorUpdate}
          className="w-full cursor-pointer rounded bg-green-500/75 disabled:bg-gray-300 enabled:hover:bg-red-500 px-4 py-2 text-white"></Button>
      </div>
      <div className="w-full col-span-1">
        <div className="flex flex-col w-full justify-center items-center">
          <label htmlFor="isPublished">Publikált oldal:</label>
          <input
            id={"isPublished"}
            key={"isPublished"}
            type={"checkbox"}
            element={"checkbox"}
            name={"isPublished"}
            label={"Publikált oldal:"}
            onChange={(e) =>
              setPublishedPage({ isPublishedPage: e.target.checked })
            }
            checked={!!state?.isPublishedPage}
            className={"flex flex-col m-2 w-6 h-6"}
          />
          <label htmlFor="showInMenu">Megjelenik a menüben:</label>
          <input
            id={"showInMenu"}
            key={"showInMenu"}
            type={"checkbox"}
            element={"checkbox"}
            name={"showInMenu"}
            label={"Megjelenik a menüben:"}
            onChange={(e) =>
              setShowPageInMenu({ showPageInMenu: e.target.checked })
            }
            checked={!!state?.showPageInMenu}
            className={"flex flex-col m-2 w-6 h-6"}
          />
          <label htmlFor="hasParent">Aloldalként megjelöl:</label>
          <input
            id={"hasParent"}
            key={"hasParent"}
            type={"checkbox"}
            element={"checkbox"}
            name={"hasParent"}
            label={"Aloldal:"}
            onChange={(e) =>
              setHasParentPage({ hasParentPage: e.target.checked })
            }
            checked={!!state?.hasParentPage}
            className={"flex flex-col m-2 w-6 h-6"}
          />
          {state?.hasParentPage && (
            <div className="w-full form-control flex flex-col m-2 ">
              <label htmlFor="selectedParent">Kiválasztott szülő oldal:</label>

              <Select
                options={pagesList}
                id="selectedParent"
                placeholder={"Válasszon szülő oldalt"}
                backspaceRemovesValue={false}
                defaultValue={state?.selectedParentPage} // default selected
                // isMulti // if multiple select
                onChange={(val, e) => {
                  // second parameter shows action triggered
                  setSelectedParentPage({ selectedParentPage: val });
                }}
                required
              />
            </div>
          )}
          {state?.selectedParentPage &&
            state?.selectedParentPage?.length > 0 &&
            state?.hasParentPage && (
              <div className={"flex flex-col m-2 self-center items-center"}>
                <h5 className="p-2 text-sm text-gray-400 self-center">
                  Jelenlegi aloldalak:
                </h5>
                <ul>
                  {subPages?.map((s, i) => {
                    return <li key={i}>- {s.value}</li>;
                  })}
                </ul>
              </div>
            )}

          <div className="flex flex-col justify-center items center"></div>
        </div>
      </div>

      {/**************************  Modals  **********************************/}
      {/* add container modal */}
      <Modal
        show={isModalOpen("containerModal")}
        onClose={() => toggleModal("containerModal")}
        title="Válasszon az alábbi konténerek közül:"
        height={"100%"}>
        <div className="flex flex-row flex-wrap justify-evenly">
          {boxColumns?.map((c, i) => {
            return (
              <div
                key={i}
                className="flex flex-row flex-nowrap mx-px my-4 w-1/6 border pointer-events-auto justify-between items-center border border-dashed border-gray-500/50 hover:border-gray-500 hover:cursor-pointer hover:bg-gray-600/75"
                onClick={() => {
                  handleAddContainer(c);
                }}>
                <div className="flex flex-row flex-nowrap w-full m-1 pointer-events-none">
                  {c?.columnSize?.map((col, idx) => {
                    const colX = col.x;
                    const colY = col.y;

                    return (
                      <div
                        key={idx}
                        className={`h-20 flex flex-row flex-nowrap justify-center items-center border border-white p-2 bg-gray-600/50 `}
                        style={{
                          width: `${((colX / colY) * 100).toFixed(0)}%`,
                        }}>
                        <p className="w-full flex flex-row justify-center items-center text-white text-sm">{`${colX}/${colY}`}</p>
                      </div>
                    );
                  })}
                </div>
              </div>
            );
          })}
        </div>
      </Modal>
    </div>
  );
};

export default EditPageEditor;
