import ElementControls from "@/components/editor/column/columnelementoption/ElementControls";
import SafeHTML from "@/components/shared/safehtml/safeHTML";
import useDynamicManager from "@/store/managers/useDynamicManager";

const PageBoxContent = ({
  data,
  alldata,
  parent,
  index,
  type,
  editSelectedElement,
}) => {
  const {
    removeElement,
    updateColumnElementOrder,
    moveColumnElement,
    cloneElement,
  } = useDynamicManager(type);
  const isCurrent =
    parseInt(data?.parentId) === parent && parseInt(data?.innerId) === index;
  if (!isCurrent || !data?.content?.length) return null;

  return data.content.map((c, i) => {
    const actions = {
      remove: () =>
        removeElement({
          parentId: parent,
          innerId: index,
          innerElementIndex: c.innerElementIndex,
        }),
      moveUp: () =>
        updateColumnElementOrder({
          parentId: parent,
          innerId: index,
          innerElementIndex: c.innerElementIndex,
          start: c.innerElementIndex - 1,
          end: c.innerElementIndex,
        }),
      moveDown: () =>
        updateColumnElementOrder({
          parentId: parent,
          innerId: index,
          innerElementIndex: c.innerElementIndex,
          start: c.innerElementIndex + 1,
          end: c.innerElementIndex,
        }),
      moveLeft: () =>
        moveColumnElement({
          parentId: parent,
          innerId: index,
          innerElementIndex: c.innerElementIndex,
          newColumnIndex: index - 1,
        }),
      moveRight: () =>
        moveColumnElement({
          parentId: parent,
          innerId: index,
          innerElementIndex: c.innerElementIndex,
          newColumnIndex: index + 1,
        }),
      clone: () =>
        cloneElement({
          parentId: parent,
          innerId: index,
          innerElementIndex: c.innerElementIndex,
        }),
    };

    return (
      <div key={i} className="flex flex-col items-center mx-4">
        <ElementControls
          c={c}
          index={index}
          parent={parent}
          currentData={data}
          alldata={alldata}
          actions={actions}
          type={type}
        />
        <div
          className="w-full p-2 bg-white font-bold text-center uppercase border border-dashed border-gray-300 hover:border-gray-600 mb-2 cursor-pointer"
          data-type={c.content?.[0]?.type}
          data-index={parent}
          data-inner-index={index}
          data-inner-element-index={c.innerElementIndex}
          onClick={editSelectedElement}>
          {c.content?.[0]?.type}
          {c.content?.[0]?.type === "title" && (
            <SafeHTML content={c.content?.[0]?.titleTextContent} />
          )}
          {c.content?.[0]?.type === "text" && (
            <SafeHTML content={c.content?.[0]?.textContent} />
          )}
        </div>
      </div>
    );
  });
};

export default PageBoxContent;
