import React from "react";
const ColumnOptions = ({
  handleClick,
  icon,
  content,
  index,
  cls,
  style,
  iconCls,
  title,
}) => {
  return (
    <div
      className={`${
        cls ?? ""
      } flex flex-row justify-center items-center cursor-pointer text-[#999999] hover:text-white border-l border-l-[#dedede] border-r border-r-[#dedede] border-b border-b-[#dedede] fill-[#999999] stroke-[#999999] bg-[#F7F7F7] hover:bg-[#999999] hover:fill-white hover:stroke-white`}
      onClick={handleClick}
      data-index={index}
      style={style}>
      <>
        {icon && (
          <span
            className={`flex w-[2rem] h-[2rem] p-1 pointer-events-none ${iconCls}`}
            title={title}>
            {icon}
          </span>
        )}
        {content && (
          <p className="flex flex-row justify-center items-center w-[2rem] h-[2rem] text-[1.25rem] pointer-events-none">
            {content}
          </p>
        )}
      </>
    </div>
  );
};

export default ColumnOptions;
