import React from "react";
import Modal from "@/components/shared/modal/Modal";

const ColumnElements = ({
  elements,
  toggleModal,
  isModalOpen,
  type,
  lifecycleHandlers = {},
}) => {
  return (
    <>
      {elements.map((element, index) => {
        const onOpen = lifecycleHandlers[element.modalName]?.onOpen;
        const onClose = lifecycleHandlers[element.modalName]?.onClose;

        return (
          <Modal
            key={index}
            title={element.title}
            show={isModalOpen(element.modalName)}
            onClose={() => {
              toggleModal(element.modalName);
              onClose?.();
            }}
            toggleModal={() => {
              console.log("element", element.modalName);
              toggleModal(element.modalName);
              onOpen?.();
            }}
            height={"100%"}>
            <div className="p-4">
              {" "}
              {React.cloneElement(element.content, {
                toggleModal,
                modalName: element.modalName,
                type: element.type || type, // Pass along the name
                lifecycleHandlers,
              })}
            </div>
          </Modal>
        );
      })}
    </>
  );
};

export default ColumnElements;
