import React, { useEffect, useState, useMemo } from "react";
import { useModalManager } from "@/hooks/useModalManager";
import { useSelector } from "react-redux";

import ColumnOptionsLayout from "./columnoptions/ColumnOptionsLayout";
import ColumnContent from "./columncontent/ColumnContent";
import AddColumnElement from "./AddColumnElement";
import Modal from "@/components/shared/modal/Modal";
import ColumnElements from "./columnelements/ColumnElements";
import selectableElementsData from "@/data/selectableElementsData";
import useDynamicManager from "@/store/managers/useDynamicManager";

const Column = ({ data, alldata, parent, index, type }) => {
  const { toggleModal, isModalOpen } = useModalManager();

  const [colSize, setColSize] = useState(null);
  const [column, setColumn] = useState(null);

  const {
    state,
    resetSliderState,
    resetGalleryState,
    resetImageState,
    resetCurrent,
  } = useDynamicManager(type);
  const editedContent = state.current;

  useEffect(() => {
    const colX = data.x;
    const colY = data.y;
    setColSize(`${colX}/${colY}`);
    setColumn(`${((100 / colY) * colX - 2).toFixed(0)}%`);
  }, [data]);

  const lifecycleHandlers = useMemo(
    () => ({
      "hero-slider": { onOpen: resetSliderState, onClose: resetSliderState },
      "image-slider": { onOpen: resetSliderState, onClose: resetSliderState },
      slider: { onOpen: resetSliderState, onClose: resetSliderState },
      gallery: { onOpen: resetGalleryState, onClose: resetGalleryState },
      "container-options": {
        onOpen: resetImageState,
        onClose: resetImageState,
      },
      "column-options": { onOpen: resetImageState, onClose: resetImageState },
      title: { onOpen: resetCurrent, onClose: resetCurrent },
      text: { onOpen: resetCurrent, onClose: resetCurrent },
    }),
    [resetSliderState, resetGalleryState, resetImageState, resetCurrent]
  );

  // General modal list for column-wide elements (used in AddColumnElement & global rendering)
  const generalElements = useMemo(() => {
    return selectableElementsData(
      editedContent,
      toggleModal,
      type,
      lifecycleHandlers
    );
  }, [editedContent, toggleModal, type, lifecycleHandlers]);

  return (
    <div
      key={index}
      className="h-auto flex flex-row flex-nowrap justify-center items-center m-2 border"
      style={{ width: column }}>
      <div className="flex flex-col w-full h-full">
        <ColumnOptionsLayout
          data={data}
          alldata={alldata}
          parent={parent}
          index={index}
          size={colSize}
          type={type}
          lifecycleHandlers={lifecycleHandlers}
        />

        {/* Content elements */}
        {alldata?.map((block, i) => {
          const isMatch =
            parseInt(block.parentId) === parent &&
            parseInt(block.innerId) === index &&
            block.content.length > 0;

          return (
            isMatch && (
              <ColumnContent
                key={`${parent}-${index}-${i}`}
                data={block}
                alldata={alldata}
                parent={parent}
                index={index}
                type={type}
                lifecycleHandlers={lifecycleHandlers}
              />
            )
          );
        })}

        {/* Add new element */}
        <AddColumnElement
          parent={parent}
          index={index}
          toggleModal={toggleModal}
          type={type}
        />
      </div>

      {/* Global Add Modal */}
      <Modal
        title={"Válasszon az alábbi elemek közül"}
        show={isModalOpen("showSelectElementModal")}
        onClose={() => toggleModal("showSelectElementModal")}
        height="100%">
        <div className="w-auto grid grid-cols-2 md:grid-cols-4 justify-center items-stretch m-4 gap-2">
          {generalElements
            .filter((e) => e?.showInElements)
            .sort((a, b) => a.sortOrder - b.sortOrder)
            .map((element, index) => (
              <button
                key={index}
                className="w-auto h-full col-span-1 flex-1 py-2 border border-gray-500/50 text-gray-600 bg-white hover:text-white hover:bg-gray-600 font-bold uppercase rounded"
                onClick={element.onClick}>
                {element.title}
              </button>
            ))}
        </div>
      </Modal>

      {/* Global Modals (column-level) */}
      <ColumnElements
        elements={generalElements}
        toggleModal={toggleModal}
        isModalOpen={isModalOpen}
        type={type}
        lifecycleHandlers={lifecycleHandlers}
      />
    </div>
  );
};

export default Column;
