import React from "react";
import Input from "@/components/shared/input/Input";
import {
  VALIDATOR_REQUIRE,
  VALIDATOR_MINLENGTH,
  VALIDATOR_MAXLENGTH,
} from "@/utils/validators";

const ArticleEditorFormFields = ({ data, handleInput, initialValid }) => {
  return (
    <>
      <Input
        element="input"
        id="articleTitle"
        type="text"
        name="articleTitle"
        placeholder="Cikk címe"
        inputcls="w-full border-1 text-center p-2 my-2 outline-blue-500"
        className="w-100"
        validators={[
          VALIDATOR_REQUIRE(),
          VALIDATOR_MINLENGTH(2),
          VALIDATOR_MAXLENGTH(254),
        ]}
        errorText={"Nem lehet üres"}
        onInput={handleInput}
        initialValid
        value={data?.articleTitle?.value}
      />
      <Input
        element="input"
        type="text"
        id="articleSlug"
        name="articleSlug"
        placeholder="Cikk url"
        className="w-100"
        inputcls="w-full border-1 text-center p-2 my-2 bg-gray-100 outline-gray-100"
        errorText={"Not valid url"}
        onInput={handleInput}
        initialValid={true}
        value={data?.articleSlug?.value}
        readOnly
      />
      {/* seo title */}
      <Input
        element="input"
        type="text"
        id="articleSeoTitle"
        name="articleSeoTitle"
        placeholder="Cikk SEO cím"
        className="w-100"
        inputcls="w-full border-1 text-center p-2 my-2"
        errorText={"Not valid url"}
        onInput={handleInput}
        initialValid={true}
        value={data?.articleSeoTitle?.value ?? ""}
      />
      {/* page link title */}
      <Input
        element="input"
        type="text"
        id="articleLinkTitle"
        name="articleLinkTitle"
        placeholder="Cikk link title"
        className="w-100"
        inputcls="w-full border-1 text-center p-2 my-2"
        errorText={"Not valid url"}
        onInput={handleInput}
        initialValid={true}
        value={data?.articleLinkTitle?.value ?? ""}
      />
      {/* page seo description */}
      <Input
        element="textarea"
        type="text"
        id="articleMetaDescription"
        name="articleMetaDescription"
        placeholder="Cikk meta leírás"
        className="w-100"
        inputcls="w-full border-1 text-center p-2 my-2"
        errorText={"Not valid url"}
        onInput={handleInput}
        initialValid={true}
        value={data?.articleMetaDescription?.value || ""}
      />
    </>
  );
};

export default ArticleEditorFormFields;
