import React, { useState, useCallback } from "react";
import dynamic from "next/dynamic";
import "react-quill/dist/quill.snow.css";
import { useSelector, useDispatch } from "react-redux";
import Button from "@/components/shared/button/Button";
import {
  selectedElement,
  updateContainerContent,
} from "@/store/slices/pageEditorSlice";
import { findLastIndexOfChar } from "@/utils/findLastIndexOfChar";
import ModalButton from "@/components/shared/modal/ModalButton";

const EditorYoutubeEmbed = ({ toggleModal, modalName }) => {
  const editableContent = useSelector(
    (state) => state.pageEditor.current.content
  );

  const dispatch = useDispatch();
  const [codeContent, setCodeContent] = useState(
    editableContent?.[0]?.content?.[0]?.codeContent ?? ""
  );

  const submitCode = useCallback(() => {
    const content = {
      type: "youtube-embed",
      title: "Youtube beágyazókód",
      codeContent: codeContent,
    };

    dispatch(
      selectedElement({
        content: content,
      })
    );
    dispatch(updateContainerContent());
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
  }, [codeContent]);
  return (
    <div className="relative">
      <div className="code-wrapper flex flex-col w-full p-4">
        {/* codeContent */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"codeContent"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap  pr-2">
            <p className="w-full font-bold">Kód: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Adjon meg a Youtube linket.
            </span>
          </label>
          <input
            type="text"
            className="w-3/4 h-auto border px-2"
            defaultValue={codeContent}
            placeholder="Adjon meg a Youtube linket."
            name={"codeContent"}
            onChange={(e) => {
              // const videoCode = findLastIndexOfChar.after(e.target.value, "/"); https://youtu.be/AnqYO0TCSG8
              setCodeContent(e.target.value);
            }}
          />
        </div>
      </div>
      <ModalButton
        disabled={!codeContent}
        btntext={"Mentés"}
        callback={submitCode}
      />
    </div>
  );
};

export default EditorYoutubeEmbed;
