import React, { useRef, useEffect } from "react";
import Image from "next/image";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import TextInput from "@/components/shared/textinput/TextInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import ApiCall from "@/api/api-calls";
import { initialData } from "@/data/data";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import ImageWithFallback from "@/components/shared/image/ImageWithFallback";

const ImageSettings = ({
  editedImage,
  overlayColor,
  setOverlayColor,
  addRef,
}) => {
  const imageRefs = useRef([]);

  useEffect(() => {
    Object.entries(imageRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });

  return (
    <div className={`w-full`}>
      {editedImage && (
        <div
          className={`flex flex-col mr-2 mb-2 items-center border-1 w-full`}
          key={editedImage?.image?._id}>
          <ImageWithFallback
            src={ApiCall.mediaStore.getResized(
              "/2/2/0",
              editedImage?.image?.originalname
            )}
            width={150}
            height={100}
            alt={editedImage.image.originalname ?? ""}
            effect="blur"
            loading="lazy"
          />
          <p className="break-all p-1">{editedImage?.image?.props?.filename}</p>
        </div>
      )}

      {/* image layer */}
      <LabeledInput
        label="Kép layer:"
        description="Megadhatja, hogy a kép fölött legyen-e egy layer. (alapértelmezett: Nincs layer a képen)">
        <SelectInput
          name="imageLayers"
          options={initialData.hasLayer}
          defaultValue={
            editedImage?.options?.imageLayers
              ? initialData.hasLayer.find(
                  (x) => x.value === editedImage?.options?.imageLayers
                )
              : initialData.hasLayer[0]
          }
          placeholder="Válasszon layer megjelenítést"
          ref={(r) => {
            imageRefs.current.imageLayers = r;
            addRef("imageLayers", r); // Explicitly add/update ref
          }}
        />
      </LabeledInput>

      {/* image layer color */}
      <LabeledInput
        label={"Kép layer színe:"}
        description={
          "Válassza ki, hogy milyen színű legyen a kép előtti layer - (alapértelmezett érték:rgba(33, 33, 33, 0.5))."
        }>
        {" "}
        <ColorPickerComponent
          name={"imageOverlayColor"}
          value={overlayColor}
          onChange={setOverlayColor}
        />
      </LabeledInput>

      {/* image url */}
      <LabeledInput
        label={"Kép link megadása:"}
        description={
          "Ha szeretné, hogy a képre kattintás más oldalra mutasson, adjon meg linket. A link megadása nem kötelező."
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"imgUrl"}
          defaultValue={editedImage?.options?.imgUrl ?? ""}
          ref={(r) => (imageRefs.current.imgUrl = r)}
        />
      </LabeledInput>

      {/* link target */}
      <LabeledInput
        label="Link célpontja:"
        description=" Ha megadott linket, ezen érték alapján nyílik a link célpontja.
      (alapértelmezett: Másik oldalt nyit a link)">
        <SelectInput
          name="imageTargets"
          options={initialData.linkTarget}
          defaultValue={
            editedImage?.options?.imageTargets
              ? initialData.linkTarget.find(
                  (x) => x.value === editedImage?.options?.imageTargets
                )
              : initialData.linkTarget[1]
          }
          placeholder="Válasszon link célpontot"
          ref={(r) => (imageRefs.current.imageTargets = r)}
        />
      </LabeledInput>

      {/* alt text */}
      <LabeledInput
        label={"Képleírás - alt text - megadása:"}
        description={
          "Adjon meg képleírást. Ez a szöveg csak a keresőrobotok és a szövegolvasó alkalmazások számára látható."
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"altText"}
          defaultValue={editedImage?.options?.altText ?? ""}
          ref={(r) => (imageRefs.current.altText = r)}
        />
      </LabeledInput>

      {/* link title */}
      <LabeledInput
        label={"Kép link cím megadása:"}
        description={
          "Adjon meg link címet (link title). Ez a szöveg csak a keresőrobotok és a szövegolvasó alkalmazások számára fontos."
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"linkTitle"}
          defaultValue={editedImage?.options?.linkTitle ?? ""}
          ref={(r) => (imageRefs.current.linkTitle = r)}
        />
      </LabeledInput>
    </div>
  );
};

export default ImageSettings;
