import React from "react";
import SliderImageItem from "./SliderImageItem";

const SliderImageList = ({
  images,
  onEdit,
  onClone,
  onOrderChange,
  onRemove,
}) => {
  if (!images || images.length === 0) {
    return <p className="text-gray-500">Nincs kép kiválasztva.</p>;
  }
  return (
    <>
      {images.map((image, index) => (
        <SliderImageItem
          key={index}
          image={image}
          index={index}
          onEdit={onEdit}
          onClone={onClone}
          onOrderChange={onOrderChange}
          onRemove={onRemove}
          isFirst={index === 0}
          isLast={index === images.length - 1}
        />
      ))}
    </>
  );
};

export default SliderImageList;
