import React from "react";
import Image from "next/image";
import icons from "@/assets/icons/icons";
import { findLastIndexOfChar } from "@/utils/findLastIndexOfChar";
import ControlButton from "@/components/shared/button/ControlButton";
import OrderControls from "@/components/shared/ordercontrol/OrderControls";
import ApiCall from "@/api/api-calls";
import ImageWithFallback from "@/components/shared/image/ImageWithFallback";

const SliderImageItem = ({
  image,
  index,
  onEdit,
  onClone,
  onOrderChange,
  onRemove,
  isFirst,
  isLast,
}) => {
  return (
    <div className="bg-white rounded-lg shadow-sm p-3 flex gap-4 items-start w-full">
      {/* Image */}
      <div className="w-24 h-24 overflow-hidden rounded-md flex-shrink-0 border">
        <ImageWithFallback
          src={ApiCall.mediaStore.getResized(
            "/4/4/1",
            image?.image?.originalname
          )}
          width={200}
          height={100}
          alt={image?.image?.originalname ?? ""}
          style={{
            // width: "100%",
            // height: "auto",
            objectFit: "contain",
          }}
          loading="lazy"
        />
      </div>

      {/* Controls */}
      <div className="flex flex-col justify-between flex-grow">
        {/* Image name */}
        <p className="text-gray-800 text-sm font-semibold truncate mb-2">
          <span className="text-gray-500 mr-1">{index + 1}.</span>
          {image?.image?.originalname}
        </p>

        {/* Control buttons */}
        <div className="flex flex-wrap items-center gap-2 mt-auto">
          <ControlButton
            icon={icons.edit}
            color="green"
            onClick={() => onEdit(image)}
            title="Szerkesztés"
          />
          <ControlButton
            icon={icons.clone}
            color="green"
            onClick={() => onClone(index)}
            title="Klónozás"
          />
          <OrderControls
            index={index}
            isFirst={isFirst}
            isLast={isLast}
            onOrderChange={onOrderChange}
          />
          <ControlButton
            icon={icons.trash}
            color="red"
            onClick={() => onRemove(image, index)}
            title="Törlés"
          />
        </div>
      </div>
    </div>
  );
};

export default SliderImageItem;
