import React from "react";
import GalleryImageItem from "./GalleryImageItem";

const GalleryImageList = ({
  images,
  onEdit,
  onClone,
  onOrderChange,
  onRemove,
}) => {
  if (!images || images.length === 0) {
    return <p className="text-gray-500">Nincs kép kiválasztva.</p>;
  }

  return (
    <div>
      {images.map((image, index) => (
        <GalleryImageItem
          key={index}
          image={image}
          index={index}
          onEdit={onEdit}
          onClone={onClone}
          onOrderChange={onOrderChange}
          onRemove={onRemove}
          isFirst={index === 0}
          isLast={index === images.length - 1}
        />
      ))}
    </div>
  );
};

export default GalleryImageList;
