import React, { useEffect, useState } from "react";

import icons from "@/assets/icons/icons";
import Image from "next/image";
import ImageWithFallback from "@/components/shared/image/ImageWithFallback";
import ApiCall from "@/api/api-calls";

const EditorGalleryImage = ({
  data,
  handleEditSingleImage,
  handleRemoveSingleImage,
}) => {
  const [imgSrc, setImgSrc] = useState(null);

  useEffect(() => {
    const src = ApiCall.getResizedImage(
      "/2/2/0/",
      data?.image?.props?.originalname
    );
    setImgSrc(src);
  }, [data]);

  return (
    <div className="flex flex-row justify-start items-center w-full bg-white">
      <div className="border p-2 text-center w-1/6 h-full flex flex-row justify-center items-center">
        .
      </div>
      <div className="flex flex-row justify-center border p-2 text-center w-3/6">
        {imgSrc && (
          <ImageWithFallback
            src={imgSrc}
            width={100}
            height={50}
            alt={data?.image?.props?.originalname}
            effect="blur"
            loading="lazy"
          />
        )}
      </div>
      <div className="flex flex-row flex-nowrap h-full text-center w-2/6">
        <div
          className=" w-1/2 border p-2 cursor-pointer flex flex-row justify-center items-center fill-green-500/50 hover:fill-green-500"
          onClick={() => handleEditSingleImage(data)}>
          {icons.edit}
        </div>
        <div
          className=" w-1/2 border p-2 cursor-pointer flex flex-row justify-center items-center fill-red-500/50 hover:fill-red-500"
          onClick={() => handleRemoveSingleImage(data)}>
          {icons.trash}
        </div>
      </div>
    </div>
  );
};

export default EditorGalleryImage;
