import React, { useRef, useState, useCallback } from "react";
import useDynamicManager from "@/store/managers/useDynamicManager";
import Select from "react-select";
import { initialData } from "@/data/data";
import SuneditorComponent from "@/components/shared/texteditor/SuneditorComponent";
import "suneditor/dist/css/suneditor.min.css";
import ModalButton from "@/components/shared/modal/ModalButton";

const EditorMap = ({ toggleModal, modalName, type }) => {
  const { state, selectedElement, addcurrentElementToColumn } =
    useDynamicManager(type);

  let index = 0;
  const inputRefs = useRef([]);
  const [textContent, setTextContent] = useState(
    state?.current?.content?.[0]?.content?.[0]?.popupContent ?? ""
  );
  // submit the map component with provided data
  const submitEditorMap = useCallback(() => {
    const content = { type: "map", title: "Térkép", popupContent: textContent };
    inputRefs.current.map((c, i) => {
      if (c) {
        if (c.props) {
          if (c.props.value?.[0]) {
            content[c.props.name] = c.props.value?.[0].value;
          } else {
            content[c.props.name] = c.props.value.value;
          }
        } else {
          content[c.name] = c.value;
        }
      }
    });

    selectedElement({
      content: content,
    });

    addcurrentElementToColumn();
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
  }, [inputRefs, textContent]);

  return (
    <div className="relative">
      <div className="map-wrapper flex flex-col w-full p-4">
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"mouseZoom"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Térkép zoomolása egérrel: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy a térképen működjön-e az egér görgőjével
              zoomolás lehetősége. (alapértelmezett: Igen)
            </span>
          </label>

          <Select
            options={initialData.editor.map.mouseZoom}
            className="w-3/4"
            menuPosition={"fixed"}
            placeholder={"Térkép zoomolása egérrel"}
            backspaceRemovesValue={false}
            name={"mouseZoom"}
            ref={(r) => (inputRefs.current[index++] = r)}
            defaultValue={
              state?.current?.content?.[0]?.content?.[0]?.mouseZoom
                ? initialData.editor.map.mouseZoom.filter(
                    (x) =>
                      x.value ===
                      state?.current?.content?.[0].content?.[0]?.mouseZoom
                  )
                : initialData.editor.map.mouseZoom[0]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"zoomLevel"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Zoom szintje: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy a térkép mennyire közelítsen rá a megadott
              koordinátákra. Teljesen ráközelítve: 20, legnagyobb terület
              mutatása: 1 (alapértelmezett: 20)
            </span>
          </label>

          <Select
            options={initialData.editor.map.zoomLevel}
            className="w-3/4"
            menuPosition={"fixed"}
            placeholder={"Zoom szintje"}
            backspaceRemovesValue={false}
            name={"zoomLevel"}
            ref={(r) => (inputRefs.current[index++] = r)}
            defaultValue={
              state?.current?.content?.[0]?.content?.[0]?.zoomLevel
                ? initialData.editor.map.zoomLevel.filter(
                    (x) =>
                      x.value ===
                      state?.current?.content?.[0].content?.[0].zoomLevel
                  )
                : initialData.editor.map.zoomLevel[19]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"lat"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Szélesség érték megadása: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Az itt megadott érték határozza meg, hogy milyen szélességi
              koordinátákat használ majd a megjelenített térkép. Például:
              47.501693948309736
            </span>
          </label>

          <input
            type="text"
            name="lat"
            id="lat"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            placeholder="Szélességi érték"
            defaultValue={state?.current?.content?.[0]?.content?.[0]?.lat ?? ""}
          />
        </div>
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"lng"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Hosszúság érték megadása: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Az itt megadott érték határozza meg, hogy milyen hosszúsági
              koordinátákat használ majd a megjelenített térkép. Például:
              19.11495245586692
            </span>
          </label>

          <input
            type="text"
            name="lng"
            id="lng"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            placeholder="Hosszúsági érték"
            defaultValue={state?.current?.content?.[0]?.content?.[0]?.lng ?? ""}
          />
        </div>
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"markerPopup"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Popup megadása: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Az itt megadott érték határozza meg, hogy a térképen a koordináták
              által megadott pontra kattintva milyen szöveg jelenik meg.
            </span>
          </label>
          <SuneditorComponent
            lang="en"
            name="textContent"
            defaultValue={textContent}
            width="100%"
            height="100%"
            placeholder="Ide gépelheti a szöveget..."
            autoFocus={false}
            onChange={(value) => setTextContent(value)}
            setOptions={{
              buttonList: [
                ["font", "fontSize", "formatBlock"],
                [
                  "bold",
                  "underline",
                  "italic",
                  "strike",
                  "subscript",
                  "superscript",
                ],
                ["align", "list", "table"],
                ["fontColor", "hiliteColor"],
                ["outdent", "indent"],
                ["undo", "redo"],
                ["removeFormat"],
                ["link", "image"],
                ["preview", "print"],
                ["fullScreen", "showBlocks", "codeView"],
              ],
              tableWidth: "100%",
              tableStyles: {
                border: "1px solid black",
              },
            }}
          />
        </div>
      </div>
      <ModalButton btntext={"Mentés"} callback={submitEditorMap} />
    </div>
  );
};

export default EditorMap;
