import React, { useRef, useState, useCallback, useEffect } from "react";
import { useSelector, useDispatch } from "react-redux";
import Select from "react-select";
import { initialData } from "@/data/data";
import useDynamicManager from "@/store/managers/useDynamicManager";
import dynamic from "next/dynamic";
import ModalButton from "@/components/shared/modal/ModalButton";

const ColorPicker = dynamic(() => import("react-best-gradient-color-picker"), {
  ssr: false,
});

const EditorLink = ({ toggleModal, modalName, type }) => {
  const { state, selectedElement, addcurrentElementToColumn } =
    useDynamicManager(type);
  const [color, setColor] = useState("");
  const editableContent = state.current.content || {};

  useEffect(() => {
    setColor(editableContent?.[0]?.content?.[0]?.fontColor ?? "#212121");
  }, []);

  let index = 0;
  const inputRefs = useRef([]);

  const submitEditorLink = useCallback(() => {
    const content = { type: "link", title: "Link", fontColor: color };

    inputRefs.current.map((c, i) => {
      if (c) {
        if (c.props) {
          if (c.props.value?.[0]) {
            content[c.props.name] = c.props.value?.[0].value;
          } else {
            content[c.props.name] = c.props.value.value;
          }
        } else {
          content[c.name] = c.value;
        }
      }
    });

    selectedElement({
      content: content,
    });

    addcurrentElementToColumn();
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
  }, [
    selectedElement,
    addcurrentElementToColumn,
    color,
    inputRefs,
    modalName,
    toggleModal,
  ]);

  return (
    <div className="relative">
      {editableContent && (
        <div className="link-wrapper flex flex-col w-full p-4">
          <div className="flex flex-row w-full mb-4 pb-4 border-b">
            <label
              htmlFor={"linkUrl"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Link url megadása: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Adjon meg link urlt. A linkre kattintással az itt megadott
                oldalra navigálhat.
              </span>
            </label>

            <input
              type="text"
              name="linkUrl"
              id="linkUrl"
              placeholder="Link url megadása"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={editableContent?.[0]?.content?.[0]?.linkUrl ?? ""}
            />
          </div>
          <div className="flex flex-row w-full mb-4 pb-4 border-b">
            <label
              htmlFor={"linkText"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Link szövegének megadása: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Adjon meg a linknél megjelenítendő szöveget.
              </span>
            </label>

            <input
              type="text"
              name="linkText"
              placeholder="Link szövegének megadása"
              id="linkText"
              className="w-3/4 border h-max p-2"
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={editableContent?.[0]?.content?.[0]?.linkText ?? ""}
            />
          </div>
          <div className="flex flex-row w-full mb-4 pb-4 border-b">
            <label
              htmlFor={"transformTypes"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">
                Link szövegének megjelenítése:{" "}
              </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a link szövege normál vagy nagybetűssé
                alakított formában jelenjen meg. (alapértelmezett: Nagybetűssé
                alakítás)
              </span>
            </label>

            <Select
              options={initialData.editor.link.transformTypes}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={"Válasszon link szöveg megjelenítési módot"}
              backspaceRemovesValue={false}
              name={"transformTypes"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                editableContent?.[0]?.content?.[0]?.transformTypes
                  ? initialData.editor.link.transformTypes.find(
                      (x) =>
                        x.value ===
                        editableContent?.[0].content?.[0]?.transformTypes
                    )
                  : initialData.editor.link.transformTypes[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          <div className="flex flex-row w-full mb-4 pb-4 border-b">
            <label
              htmlFor={"linkTitle"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">
                Link címének (title) megadása:{" "}
              </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Az itt megadott érték csak a keresőmotorok és a szövegolvasók
                számára látható, illetve abban az esetben, ha a link fölé
                visszük az egeret.
              </span>
            </label>

            <input
              type="text"
              name="linkTitle"
              id="linkTitle"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={editableContent?.[0]?.content?.[0]?.linkTitle ?? ""}
            />
          </div>
          <div className="flex flex-row w-full mb-4 pb-4 border-b">
            <label
              htmlFor={"textAlignment"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Link szövegének rendezése: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a link szövege milyen elrendezésben jelenjen
                meg. (alapértelmezett: Középre zárt)
              </span>
            </label>

            <Select
              options={initialData.editor.link.textAlignment}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={"Válasszon link szöveg rendezési módot"}
              backspaceRemovesValue={false}
              name={"textAlignment"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                editableContent?.[0]?.content?.[0]?.textAlignment
                  ? initialData.editor.link.textAlignment.find(
                      (x) =>
                        x.value ===
                        editableContent?.[0].content?.[0].textAlignment
                    )
                  : initialData.editor.link.textAlignment[1]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>

          <div className="flex flex-row w-full mb-4 pb-4 border-b">
            <label
              htmlFor={"linkSizes"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Link helykitöltése: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a link kitöltse-e a teljes rendelkezésre álló
                helyet. (alapértelmezett: Nem)
              </span>
            </label>

            <Select
              options={initialData.editor.link.linkSpan}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Válassza ki, hogy a link kitöltse-e a teljes rendelkezésre álló helyet"
              }
              backspaceRemovesValue={false}
              name={"linkSpan"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                editableContent?.[0]?.content?.[0].linkSpan
                  ? initialData.editor.link.linkSpan.find(
                      (x) =>
                        x.value == editableContent?.[0].content?.[0].linkSpan
                    )
                  : initialData.editor.link.linkSpan[1]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          {/* font color */}
          <div className="flex flex-row w-full mb-4 pb-4 border-b">
            <label
              htmlFor={"fontColor"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Betű szín: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy milyen színű legyen a link elem -
                (alapértelmezett érték: #212121 - Fekete).
              </span>
            </label>

            <ColorPicker value={color} onChange={setColor} />
          </div>
        </div>
      )}

      <ModalButton btntext={"Mentés"} callback={submitEditorLink} />
    </div>
  );
};

export default EditorLink;
