import React, { useState, useRef, useCallback, useEffect } from "react";
import Wrapper from "../Wrapper/Wrapper";
import MediaObject from "../MediaObject/MediaObject";
import Image from "next/image";
import { findLastIndexOfChar } from "../../Utils/findLastIndexOfChar";
import useSWR from "swr";
import { selectedSliderImages } from "../../redux/pageEditorSlice";
import { uniq, range } from "lodash";
import Button from "../Button/Button";
import { useSelector, useDispatch } from "react-redux";

const EditorSliderSelect = ({ images, showSelectImageModal }) => {
  const dispatch = useDispatch();
  const [checked, setChecked] = useState([]);
  const lastChecked = useRef(null);
  const checkedListRef = useRef([]);
  const selectedSliderImagesList = useSelector(
    (state) => state.pageEditor.sliderImages
  );

  const handleChange = useCallback((e) => {
    const index = Number(e.target.dataset.index);

    if (lastChecked.current !== null && e.nativeEvent.shiftKey) {
      setChecked((prev) => {
        const start = Math.min(lastChecked.current, index);
        const end = Math.max(lastChecked.current, index);
        return uniq([...prev, ...range(start, end), end]);
      });
      return;
    }
    if (e.target.checked) {
      lastChecked.current = index;
      setChecked((prev) => [...prev, index]);
    } else {
      lastChecked.current = null;
      setChecked((prev) => prev.filter((i) => i !== index));
    }
  }, []);

  const handleImageSelect = useCallback(() => {
    showSelectImageModal(false);
    let ret = [],
      isChecked = {};
    checkedListRef.current.map((c, i) => {
      if (c.checked) {
        isChecked = images.filter((x) => x._id === c.id);
        ret.push({ image: isChecked[0], options: {} });
      }
    });

    dispatch(
      selectedSliderImages({
        selectedImages: ret,
      })
    );
  }, [images]);

  return (
    <>
      <Wrapper className="flex flex-row flex-nowrap">
        <div className="flex flex-nowrap justify-center items-center">
          {/* {selectedCnt + " file(s) selected"} */}
        </div>
        <div className="flex flex-wrap">
          <Button
            key={"select"}
            className="py-1 px-2 bg-red-500/75 hover:bg-red-500 rounded"
            btntext={"Kiválaszt"}
            onClick={handleImageSelect}></Button>
        </div>
      </Wrapper>
      <Wrapper className="flex flex-row flex-wrap items-center justify-start">
        {images &&
          images?.map((l, i) => {
            switch (l?.props?.mimetype) {
              case "application/pdf":
                return (
                  <Wrapper
                    className={`flex flex-col mr-2 mb-2 items-center border-1`}
                    key={i}>
                    <MediaObject
                      data={l}
                      index={i}
                      data-index={i}
                      className={"w-full"}
                      id={l._id}
                    />
                    <p className="break-all p-1">{l?.props?.filename}</p>
                    <label className="flex flex-row justify-center items-center">
                      <input
                        checked={checked.includes(i)}
                        data-index={i}
                        type="checkbox"
                        ref={(r) => (checkedListRef.current[i] = r)}
                        onChange={handleChange}
                        className="w-6 h-6 m-2 "
                        id={l._id}
                      />
                      {checked.includes(i) ? "Kiválasztva" : "Kiválaszt"}
                    </label>
                  </Wrapper>
                );
              default:
                return (
                  <Wrapper
                    className={`flex flex-col  mr-2 mb-2 items-center border-1`}
                    key={i}>
                    <Image
                      src={
                        `${process.env.PATH}/api/admin/i/2/2/0/` +
                        findLastIndexOfChar.before(l?.originalname, ".") +
                        ".webp"
                      }
                      width={150}
                      height={100}
                      alt={l?.originalname ?? ""}
                      effect="blur"
                      loading="lazy"
                    />
                    <p className="break-all p-1 text-sm">
                      {l?.props?.filename}
                    </p>
                    <label className="flex flex-row justify-center items-center">
                      <input
                        checked={checked.includes(i)}
                        data-index={i}
                        type="checkbox"
                        ref={(r) => (checkedListRef.current[i] = r)}
                        onChange={handleChange}
                        className="w-6 h-6 m-2 "
                        id={l._id}
                      />
                      {checked.includes(i) ? "Kiválasztva" : "Kiválaszt"}
                    </label>
                  </Wrapper>
                );
            }
          })}
      </Wrapper>
    </>
  );
};

export default EditorSliderSelect;
