import React, { useCallback, useState, useRef, useEffect } from "react";
import Button from "@/components/shared/button/Button";
import Select from "react-select";
import { initialData } from "@/data/data";
import Modal from "@/components/shared/modal/Modal";
import icons from "@/assets/icons/icons";
import ImageWithFallback from "@/components/shared/image/ImageWithFallback";
import EditImageOptions from "./EditImageOptions";
import useDynamicManager from "@/store/managers/useDynamicManager";
import MediaGalleryModal from "@/components/media-store/GalleryModal/MediaGalleryModal";
import ApiCall from "@/api/api-calls";
import EditSliderImageOptions from "../EditorSlider/EditSliderImageOptions";
import EditorSliderImageList from "./EditorSliderImageList";

const EditorImageSlider = ({
  toggleModal,
  modalName,
  type,
  lifecycleHandlers,
}) => {
  const {
    state,
    selectedElement,
    setEditedElement,
    updateSliderImage,
    setSelectedSliderImages,
    removeSingleSliderImage,
    resetSliderState,
    updateSliderImageOrder,
    cloneSliderImage,
    addcurrentElementToColumn,
  } = useDynamicManager(type);

  const [selectImageModal, showSelectImageModal] = useState(false);
  const [editImageModal, showEditImageModal] = useState(false);
  const [editedImage, setEditedImage] = useState({});
  const inputRefs = useRef([]);

  let index = 0;

  const handleEditSingleImage = (image) => {
    setEditedImage(image);
    showEditImageModal(true);
  };

  const handleRemoveSingleImage = useCallback(
    (image, index) => {
      removeSingleSliderImage({
        id: image.image._id,
        index: index,
      });
    },
    [removeSingleSliderImage]
  );

  useEffect(() => {
    const initialImages = state?.current?.content?.[0]?.content?.[0]?.images;

    if (
      initialImages &&
      initialImages.length > 0 &&
      state?.sliderImages?.length === 0
    ) {
      setSelectedSliderImages({ selectedImages: initialImages });
    }
  }, [state?.current?.content, state?.sliderImages?.length]);

  const handleCloneSliderImage = useCallback((i) => {
    cloneSliderImage({ selected: i });
  }, []);

  const handleUpdateSliderImageOrder = useCallback((start, end) => {
    updateSliderImageOrder({ start, end });
  }, []);

  const generateSelectedImage = useCallback(() => {
    return (
      <EditorSliderImageList
        images={state?.sliderImages}
        onEdit={handleEditSingleImage}
        onClone={handleCloneSliderImage}
        onOrderChange={handleUpdateSliderImageOrder}
        onRemove={handleRemoveSingleImage}
      />
    );
  }, [
    state?.sliderImages,

    handleRemoveSingleImage,
    handleCloneSliderImage,
    handleUpdateSliderImageOrder,
  ]);

  const handleSliderImagesSubmit = useCallback(() => {
    const ret = {
      type: "image-slider",
      images: state?.sliderImages,
    };
    inputRefs.current.map((c, i) => {
      if (c) {
        if (c.props) {
          if (c.props.value[0]) {
            ret[c.props.name] = c.props.value[0].value;
          } else {
            ret[c.props.name] = c.props.value.value;
          }
        } else {
          ret[c.name] = c.value;
        }
      }
    });

    selectedElement({
      content: ret,
    });

    addcurrentElementToColumn();
    resetSliderState();
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
    showSelectImageModal(false);
  }, [
    state?.sliderImages,
    inputRefs,
    addcurrentElementToColumn,
    resetSliderState,
    selectedElement,
    toggleModal,
    modalName,
  ]);
  const handleSetSelectedSliderImages = useCallback((images) => {
    const ret = [];
    images?.map((image) => ret.push({ image: image, options: {} }));
    setSelectedSliderImages({ selectedImages: ret });
  }, []);
  const handleInputMinMax = (e) => {
    if (parseInt(e.target.value) > parseInt(e.target.max)) {
      e.target.value = parseInt(e.target.max);
    }
    if (parseInt(e.target.value) < parseInt(e.target.min)) {
      e.target.value = parseInt(e.target.min);
    }
    e.target.value = parseInt(e.target.value);
    return e.target.value;
  };

  const handleUpdateSliderImage = useCallback(
    (image, options) => {
      updateSliderImage({
        id: image._id,
        image: image,
        options: options,
      });
    },
    [updateSliderImage]
  );

  return (
    <div className="relative h-max">
      <div className="slider-div grid grid-cols-1 md:grid-cols-6 w-full h-full">
        <div className="col-span-2 bg-gray-100 h-full p-4 h-[80vh] overflow-y-scroll flex flex-col">
          <h5 className="text-normal text-gray-400 w-full font-bold">
            Kép lista:
          </h5>
          {generateSelectedImage()}
        </div>
        <div className="col-span-4 h-full flex flex-col border-l">
          {/* image upload */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"imageSelect"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Kép(ek) feltöltése: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Töltsön fel képet, vagy válasszon a médiatárból!
              </span>
            </label>
            <div className="flex flex-row w-3/4 justify-end items-center">
              <Button
                onClick={() => showSelectImageModal(true)}
                className=" border border-gray-300 px-4 py-2 text-gray-500 hover:border-gray-600 hover:text-gray-900"
                btntext="Kép(ek) kiválasztása"></Button>
            </div>
          </div>
          {/* image grayscale */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"imageGrayScale"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Kép(ek) szürkeárnyalat érték: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Megadhatja, hogy a képeknek legyen-e szürkeárnyalata. Érték:
                0-100. (Alapértelmezett: 0)
              </span>
            </label>
            <input
              type="text"
              name="imageGrayScale"
              id="imageGrayScale"
              ref={(r) => (inputRefs.current[index++] = r)}
              onChange={(e) => handleInputMinMax(e)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.imageGrayScale ?? 0
              }
            />
          </div>
          {/* image alignment */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"alignment"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Képek elrendezése: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider képei hogyan legyenek elrendezve.
                (alapértelmezett: Középre zárt)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.alignment}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={"Válasszon kép elrendezést"}
              backspaceRemovesValue={false}
              name={"alignment"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.alignment
                  ? initialData.editor.slider.alignment.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].alignment
                    )
                  : initialData.editor.slider.alignment[1]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          {/* slider autoplay */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"autoplay"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider automatikus lejátszása:</p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider automatikusan elinduljon-e.
                (alapértelmezett: Igen)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.autoplay}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={"Válasszon slider automatikus lejátszást"}
              backspaceRemovesValue={false}
              name={"autoplay"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.autoplay
                  ? initialData.editor.slider.autoplay.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].autoplay
                    )
                  : initialData.editor.slider.autoplay[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          {/* slider items smooth height */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"alignment"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">
                Slider elemek azonos magassága:{" "}
              </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider képei azonos magasságúak legyenek-e.
                (alapértelmezett: Nem)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.smoothHeight}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Válasszon. hogy azonos magasságúak legyenek-e az elemek"
              }
              backspaceRemovesValue={false}
              name={"smoothHeight"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.smoothHeight
                  ? initialData.editor.slider.smoothHeight.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].smoothHeight
                    )
                  : initialData.editor.slider.smoothHeight[1]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          {/* slider items per view */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"slidesPerView"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider elemek száma: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider képei közel mennyi látszódjon egy
                oldalon. (alapértelmezett: 3)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.slidesPerView}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Válassza ki, hogy a slider képei közel mennyi látszódjon egy oldalon"
              }
              backspaceRemovesValue={false}
              name={"slidesPerView"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.slidesPerView
                  ? initialData.editor.slider.slidesPerView.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].slidesPerView
                    )
                  : initialData.editor.slider.slidesPerView[2]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          {/* slider items on breakpoints */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"sliderBreakpointXxs"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider elemek száma - XXS: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider képei közel mennyi látszódjon egy
                oldalon. (alapértelmezett: 1)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.slidesPerView}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Válassza ki, hogy a slider képei közel mennyi látszódjon egy oldalon"
              }
              backspaceRemovesValue={false}
              name={"sliderBreakpointXxs"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.sliderBreakpointXxs
                  ? initialData.editor.slider.slidesPerView.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0]
                          .sliderBreakpointXxs
                    )
                  : initialData.editor.slider.slidesPerView[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"sliderBreakpointXs"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider elemek száma - XS: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider képei közel mennyi látszódjon egy
                oldalon. (alapértelmezett: 1)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.slidesPerView}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Válassza ki, hogy a slider képei közel mennyi látszódjon egy oldalon"
              }
              backspaceRemovesValue={false}
              name={"sliderBreakpointxs"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.sliderBreakpointxs
                  ? initialData.editor.slider.slidesPerView.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].sliderBreakpointxs
                    )
                  : initialData.editor.slider.slidesPerView[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"sliderBreakpointSm"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider elemek száma - SM: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider képei közel mennyi látszódjon egy
                oldalon. (alapértelmezett: 1)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.slidesPerView}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Válassza ki, hogy a slider képei közel mennyi látszódjon egy oldalon"
              }
              backspaceRemovesValue={false}
              name={"sliderBreakpointSm"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.sliderBreakpointSm
                  ? initialData.editor.slider.slidesPerView.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].sliderBreakpointSm
                    )
                  : initialData.editor.slider.slidesPerView[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"sliderBreakpointMd"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider elemek száma - MD: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider képei közel mennyi látszódjon egy
                oldalon. (alapértelmezett: 1)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.slidesPerView}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Válassza ki, hogy a slider képei közel mennyi látszódjon egy oldalon"
              }
              backspaceRemovesValue={false}
              name={"sliderBreakpointMd"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.sliderBreakpointMd
                  ? initialData.editor.slider.slidesPerView.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].sliderBreakpointMd
                    )
                  : initialData.editor.slider.slidesPerView[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"sliderBreakpointLg"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider elemek száma - LG: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider képei közel mennyi látszódjon egy
                oldalon. (alapértelmezett: 1)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.slidesPerView}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Válassza ki, hogy a slider képei közel mennyi látszódjon egy oldalon"
              }
              backspaceRemovesValue={false}
              name={"sliderBreakpointLg"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.sliderBreakpointLg
                  ? initialData.editor.slider.slidesPerView.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].sliderBreakpointLg
                    )
                  : initialData.editor.slider.slidesPerView[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"sliderBreakpointXl"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider elemek száma - XL: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider képei közel mennyi látszódjon egy
                oldalon. (alapértelmezett: 1)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.slidesPerView}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Válassza ki, hogy a slider képei közel mennyi látszódjon egy oldalon"
              }
              backspaceRemovesValue={false}
              name={"sliderBreakpointXl"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.sliderBreakpointXl
                  ? initialData.editor.slider.slidesPerView.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].sliderBreakpointXl
                    )
                  : initialData.editor.slider.slidesPerView[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"sliderBreakpoint2Xl"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider elemek száma - 2XL: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider képei közel mennyi látszódjon egy
                oldalon. (alapértelmezett: 1)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.slidesPerView}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Válassza ki, hogy a slider képei közel mennyi látszódjon egy oldalon"
              }
              backspaceRemovesValue={false}
              name={"sliderBreakpoint2Xl"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.sliderBreakpoint2Xl
                  ? initialData.editor.slider.slidesPerView.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0]
                          .sliderBreakpoint2Xl
                    )
                  : initialData.editor.slider.slidesPerView[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          {/* slider items space between */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"spaceBetween"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">
                Slider elemek közötti távolság:{" "}
              </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider képei milyen távolságban legyenek
                egymástól. (alapértelmezett: 10)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.spaceBetween}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={"Válassza ki a slider képek távolságát"}
              backspaceRemovesValue={false}
              name={"spaceBetween"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.spaceBetween
                  ? initialData.editor.slider.spaceBetween.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].spaceBetween
                    )
                  : initialData.editor.slider.spaceBetween[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          {/* slider items mouseWheelControl */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"mouseWheelControl"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">
                Slider egér görgővel vezérelhető:{" "}
              </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider egér görgővel vezérelhető legyen-e.
                (alapértelmezett: igen)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.mouseWheelControl}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={"Kapcsolja ki vagy be az egér görgővel vezérlést"}
              backspaceRemovesValue={false}
              name={"mouseWheelControl"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.mouseWheelControl
                  ? initialData.editor.slider.mouseWheelControl.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].mouseWheelControl
                    )
                  : initialData.editor.slider.mouseWheelControl[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          {/* slider items keyboardControl */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"keyboardControl"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">
                Slider billentyűzettel vezérelhető:{" "}
              </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider billentyűzettel vezérelhető legyen-e.
                (alapértelmezett: igen)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.keyboardControl}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={"Kapcsolja ki vagy be a billentyűzettel vezérlést"}
              backspaceRemovesValue={false}
              name={"keyboardControl"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.keyboardControl
                  ? initialData.editor.slider.keyboardControl.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].keyboardControl
                    )
                  : initialData.editor.slider.keyboardControl[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          {/* slider items pagination */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"pagination"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider oldalak jelzése: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider oldalakat jelezze-e a slider.
                (alapértelmezett: igen)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.pagination}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Kapcsolja ki vagy be a slider oldalait jelezze-e a rendszer"
              }
              backspaceRemovesValue={false}
              name={"pagination"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.pagination
                  ? initialData.editor.slider.pagination.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].pagination
                    )
                  : initialData.editor.slider.pagination[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          {/* slider items navigation */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"navigation"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider navigáció jelzése: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider navigáció látható legyen-e.
                (alapértelmezett: nem)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.navigation}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Válassza ki, hogy a slider navigáció látható legyen-e"
              }
              backspaceRemovesValue={false}
              name={"navigation"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.navigation
                  ? initialData.editor.slider.navigation.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].navigation
                    )
                  : initialData.editor.slider.navigation[1]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          {/* slider items zoom */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"zoom"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider zoom: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy a slider képei zoomolhatóak legyenek-e.
                (alapértelmezett: igen)
              </span>
            </label>

            <Select
              options={initialData.editor.slider.zoom}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={
                "Válassza ki, hogy a slider képei zoomolhatóak legyenek-e"
              }
              backspaceRemovesValue={false}
              name={"zoom"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.zoom
                  ? initialData.editor.slider.zoom.filter(
                      (x) =>
                        x.value === state?.current?.content[0].content[0].zoom
                    )
                  : initialData.editor.slider.zoom[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
          {/* slider items animation */}
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"animationTypes"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Slider elemek animációja: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki a slider elemek animációját. (alapértelmezett: Nincs
                animáció)
              </span>
            </label>

            <Select
              options={initialData.animation}
              className="w-3/4"
              menuPosition={"fixed"}
              placeholder={"Válasszon animáció típust"}
              backspaceRemovesValue={false}
              name={"animationTypes"}
              ref={(r) => (inputRefs.current[index++] = r)}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.animationTypes
                  ? initialData.animation.filter(
                      (x) =>
                        x.value ===
                        state?.current?.content[0].content[0].animationTypes
                    )
                  : initialData.animation[0]
              }
              onChange={(val, e) => {
                // second parameter shows action triggered
                // dispatch(selectParentPage({ parent: val }));
              }}
              required
            />
          </div>
        </div>
      </div>
      <div className="flex flex-row w-full justify-end sticky bottom-0 bg-white p-2 border border-t">
        <Button
          className="px-4 py-2 uppercase border bg-green-500/75 text-white hover:border-green-500 hover:bg-green-500 disabled:bg-gray-500 disabled:pointer-events-none"
          btntext="Mentés"
          onClick={handleSliderImagesSubmit}
        />
      </div>
      {/* image modal */}
      <MediaGalleryModal
        isOpen={selectImageModal}
        onClose={() => {
          showSelectImageModal(false);
        }}
        onOpen={() => alert("!")}
        action="editorSlider"
        onConfirmSelection={(selectedImages) =>
          handleSetSelectedSliderImages(selectedImages)
        }
      />

      <Modal
        title={"Slider kép szerkesztése"}
        show={editImageModal}
        onClose={() => showEditImageModal(false)}
        height={"100%"}>
        {editedImage && Object.keys(editedImage).length > 0 && (
          <EditSliderImageOptions
            editedImage={editedImage}
            setEditedImage={setEditedImage}
            showEditImageModal={showEditImageModal}
            handleUpdateSliderImage={handleUpdateSliderImage}
          />
        )}
      </Modal>
    </div>
  );
};

export default EditorImageSlider;
