import React, { useRef, useEffect } from "react";
import { initialData } from "@/data/data";
import Button from "@/components/shared/button/Button";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import TextInput from "@/components/shared/textinput/TextInput";
import useDynamicManager from "@/store/managers/useDynamicManager";

const ImageSettings = ({
  generateSelectedImage,
  showSelectImageModal,

  addRef,
  type,
}) => {
  const inputRefs = useRef([]);
  const { state } = useDynamicManager(type);

  const content = state?.current?.content?.[0]?.content?.[0] ?? {};

  useEffect(() => {
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });

  return (
    <div>
      {content && (
        <>
          {" "}
          {/* Image selector */}
          <div className="flex flex-row w-full my-4 pb-4">
            <label
              htmlFor={"imageSelect"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Kép kiválasztása: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Töltsön fel képet, vagy válasszon a médiatárból!
              </span>
            </label>
            <div className="flex flex-row w-3/4 justify-end items-center">
              {generateSelectedImage()}
              <Button
                onClick={() => showSelectImageModal(true)}
                className="border border-gray-300 px-4 py-2 text-gray-500 hover:border-gray-600 hover:text-gray-900"
                btntext="Kép kiválasztása"
              />
            </div>
          </div>
          {/* imageType */}
          <LabeledInput
            label={"Kép típusa:"}
            description={
              "Válassza ki, hogy Kép vagy Háttérkép elemet szeretne hozzáadni (alapértelmezett: Kép)"
            }>
            <SelectInput
              name="imageType"
              options={initialData.imageTypes}
              defaultValue={
                content.imageType
                  ? initialData.imageTypes.find(
                      (x) => x.value === content.imageType
                    )
                  : initialData.imageTypes[0]
              }
              placeholder="Kép típusa"
              ref={(r) => (inputRefs.current.imageType = r)}
            />
          </LabeledInput>
          {/* imageBackgroundPosition */}
          <LabeledInput
            label={"Kép pozíciója:"}
            description={
              "Válassza ki a háttér megjelenítése pozícióját. Csak abban az esetben érvényesül, ha a kép típusa: Háttérkép (alapértelmezett: Inherit - Örökölt)"
            }>
            <SelectInput
              name="imageBackgroundPosition"
              options={initialData.backgroundPosition}
              defaultValue={
                initialData.backgroundPosition.find(
                  (x) => x.value === content.imageBackgroundPosition
                ) ?? initialData.backgroundPosition[0]
              }
              placeholder="Kép pozíciója"
              ref={(r) => (inputRefs.current.imageBackgroundPosition = r)}
            />
          </LabeledInput>
          {/* imageObjectFit */}
          <LabeledInput
            label={"Kép objektum illeszkedése:"}
            description={
              "Válassza ki, hogy a képet tartalmazó dobozban hogyan viselkedjen a kép. Alapértelmezett: Cover (Kitölti a teljes doboz méretet)"
            }>
            <SelectInput
              name="imageObjectFit"
              options={initialData.objectFit}
              defaultValue={
                initialData.objectFit.find(
                  (x) => x.value === content.imageObjectFit
                ) ?? initialData.objectFit[0]
              }
              placeholder="Kép objektum illeszkedése"
              ref={(r) => (inputRefs.current.imageObjectFit = r)}
            />
          </LabeledInput>
          {/* imageObjectPosition */}
          <LabeledInput
            label={"Kép objektum pozíciója:"}
            description={
              "Válassza ki, hogy a képet tartalmazó dobozban hogyan viselkedjen a kép. Alapértelmezett: Cover (Kitölti a teljes doboz méretet)"
            }>
            <SelectInput
              name="imageObjectPosition"
              options={initialData.objectPosition}
              defaultValue={
                initialData.objectPosition.find(
                  (x) => x.value === content.imageObjectPosition
                ) ?? initialData.objectPosition[0]
              }
              placeholder="Kép objektum pozíciója"
              ref={(r) => (inputRefs.current.imageObjectPosition = r)}
            />
          </LabeledInput>
          {/* imgWidthPercent */}
          <LabeledInput
            label={"Kép szélességének megadása %-ban:"}
            description={"Adja meg a kép szélességét... Alapértelmezett: 100%"}>
            <TextInput
              type="text"
              name="imgWidthPercent"
              defaultValue={content.imgWidthPercent ?? 100}
              ref={(r) => (inputRefs.current.imgWidthPercent = r)}
            />
          </LabeledInput>
          {/* imgMaxHeight */}
          <LabeledInput
            label={"Kép maximális magasságának megadása:"}
            description={
              "Adja meg a kép maximális magasságát... Alapértelmezett: 0"
            }>
            <TextInput
              type="text"
              name="imgMaxHeight"
              defaultValue={content.imgMaxHeight ?? "unset"}
              ref={(r) => (inputRefs.current.imgMaxHeight = r)}
            />
          </LabeledInput>
          {/* image dimensions */}
          <LabeledInput
            label={"Kép dimenziójának megadása:"}
            description={
              "Adjon meg aránypárt, amely alapján a kép generálódik..."
            }>
            <div className="w-full flex flex-row flex-nowrap justify-between">
              <TextInput
                type="text"
                name="imgWidth"
                defaultValue={content.imgWidth ?? 4}
                ref={(r) => (inputRefs.current.imgWidth = r)}
              />
              <TextInput
                type="text"
                name="imgHeight"
                defaultValue={content.imgHeight ?? 3}
                ref={(r) => (inputRefs.current.imgHeight = r)}
              />
            </div>
          </LabeledInput>
          {/* imageCutToSize */}
          <LabeledInput
            label={"Kép vágása:"}
            description={
              "Válassza ki, hogy a kép vágva legyen-e a megadott arányra. Alapértelmezett: Igen"
            }>
            <SelectInput
              name="imageCutToSize"
              options={initialData.bool}
              defaultValue={
                initialData.bool.find(
                  (x) => x.value === content.imageCutToSize
                ) ?? initialData.bool[0]
              }
              placeholder="Kép vágása"
              ref={(r) => (inputRefs.current.imageCutToSize = r)}
            />
          </LabeledInput>
          {/* imageSizeType - pixel, ratio */}
          <LabeledInput
            label={"Kép méretezés típusa:"}
            description={
              "Válassza ki, hogy a kép pixelben vagy méretarány alapján kerüljön generálásra. Alapértelmezett: Arány"
            }>
            <SelectInput
              name="imageSizeType"
              options={initialData.imageSizeType}
              defaultValue={
                initialData.imageSizeType.find(
                  (x) => x.value === content.imageSizeType
                ) ?? initialData.imageSizeType[0]
              }
              placeholder="Kép vágása"
              ref={(r) => (inputRefs.current.imageSizeType = r)}
            />
          </LabeledInput>
          {/* imgQuality */}
          <LabeledInput
            label={"Képminőség megadása:"}
            description={"Adjon meg képminőséget. Százalékos értékben..."}>
            <TextInput
              type="text"
              name="imgQuality"
              defaultValue={content.imgQuality ?? 100}
              ref={(r) => (inputRefs.current.imgQuality = r)}
            />
          </LabeledInput>
          {/* altText */}
          <LabeledInput
            label={"Képleírás - alt text - megadása:"}
            description={
              "Adjon meg képleírást. Ez a szöveg csak a keresőrobotok és a szövegolvasó alkalmazások számára látható."
            }>
            <TextInput
              type="text"
              name="altText"
              defaultValue={content.altText ?? ""}
              ref={(r) => (inputRefs.current.altText = r)}
            />
          </LabeledInput>
          {/* imgUrl */}
          <LabeledInput
            label={"Kép link megadása:"}
            description={
              "Ha szeretné, hogy a képre kattintás más oldalra mutasson..."
            }>
            <TextInput
              type="text"
              name="imgUrl"
              defaultValue={content.imgUrl ?? ""}
              ref={(r) => (inputRefs.current.imgUrl = r)}
            />
          </LabeledInput>
          {/* imageTargets */}
          <LabeledInput
            label={"Link célpontja:"}
            description={
              "Ha megadott linket, ezen érték alapján nyílik a link célpontja..."
            }>
            <SelectInput
              name="imageTargets"
              options={initialData.linkTarget}
              value={
                initialData.linkTarget.find(
                  (x) => x.value === content.imageTargets
                ) ?? initialData.linkTarget[1]
              }
              placeholder="Link célpontja"
              ref={(r) => (inputRefs.current.imageTargets = r)}
            />
          </LabeledInput>
        </>
      )}
    </div>
  );
};

export default ImageSettings;
