import React, { useRef, useEffect } from "react";
import { initialData } from "@/data/data";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import TextInput from "@/components/shared/textinput/TextInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import useDynamicManager from "@/store/managers/useDynamicManager";

const ImageDesign = ({
  addRef,
  color,
  setColor,
  overlayColor,
  setOverlayColor,
  type,
}) => {
  const inputRefs = useRef([]);
  const { state } = useDynamicManager(type);
  const content = state?.current?.content?.[0]?.content?.[0] ?? {};

  useEffect(() => {
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });
  return (
    <>
      {content && (
        <div className="flex flex-col w-full my-4 pb-4">
          {" "}
          {/* image layer */}
          <LabeledInput
            label={"Kép layer:"}
            description={
              "Megadhatja, hogy a kép fölött legyen-e egy layer. (alapértelmezett: Nincs layer a képen)"
            }>
            <SelectInput
              name="imageLayers"
              options={initialData.hasLayer}
              defaultValue={
                content?.imageLayers
                  ? initialData.hasLayer.find(
                      (x) => x.value === content?.imageLayers
                    )
                  : initialData.hasLayer[0]
              }
              placeholder="Kép layer"
              ref={(r) => (inputRefs.current.imageLayers = r)}
            />
          </LabeledInput>
          {/* image layer color */}
          <LabeledInput
            label={"Kép layer színe:"}
            description={
              "Válassza ki, hogy milyen színű legyen a kép előtti layer - (alapértelmezett érték:rgba(33, 33, 33, 0.5))."
            }>
            {" "}
            <ColorPickerComponent
              name={"imgOverlayColor"}
              value={content?.imgOverlayColor ?? overlayColor}
              onChange={setOverlayColor}
            />
          </LabeledInput>
          {/* image border size */}
          <LabeledInput
            label={"Kép keret vastagságának megadása:"}
            description={
              "Megadhatja, hogy milyen vastag legyen a kép körüli keret. Az érték 0-50-ig állítható. Alapértelmezett: 0."
            }>
            <TextInput
              type={"text"}
              name={"imgBorderSize"}
              defaultValue={content?.imgBorderSize ?? 0}
              ref={(r) => (inputRefs.current.imgBorderSize = r)}
            />
          </LabeledInput>
          {/* image border type */}
          <LabeledInput
            label={"Kép keret típusa:"}
            description={
              " Válassza ki, hogy a kép keretének milyen típusa legyen. Alapértelmezett: Solid"
            }>
            <SelectInput
              name="imageBorderTypes"
              options={initialData.borderStyle}
              defaultValue={
                content?.imageBorderTypes
                  ? initialData.borderStyle.find(
                      (x) => x.value === content?.imageBorderTypes
                    )
                  : initialData.borderStyle[2]
              }
              placeholder="Kép keret típusa"
              ref={(r) => (inputRefs.current.imageBorderTypes = r)}
            />
          </LabeledInput>
          {/* image border color */}
          <LabeledInput
            label={"Kép keret színének kiválasztása:"}
            description={
              " Megadhatja, hogy milyen színű legyen a kép körüli keret. Alapértelmezett: #212121"
            }>
            {" "}
            <ColorPickerComponent
              name={"imgBorderColor"}
              value={content?.imgBorderColor ?? color}
              onChange={setColor}
            />
          </LabeledInput>
          {/* image border radius */}
          <LabeledInput
            label={"Kép kerekítésének megadása - border-radius:"}
            description={
              "Megadhatja, hogy mennyire legyen lekerekítve a kép. Az értéket px-ben, vagy %-ban kell megadni. Alapértelmezett: 0"
            }>
            <TextInput
              type={"text"}
              name={"imgBorderRadius"}
              defaultValue={content?.imgBorderRadius ?? 0}
              ref={(r) => (inputRefs.current.imgBorderRadius = r)}
            />
          </LabeledInput>
        </div>
      )}
    </>
  );
};

export default ImageDesign;
