import React, { useState, useCallback, useRef } from "react";
import useDynamicManager from "@/store/managers/useDynamicManager";
import ModalButton from "@/components/shared/modal/ModalButton";
import { useEditorImage } from "@/hooks/useEditorImage";
import TabSwitcher from "@/components/shared/tabswitcher/TabSwitcher";
import ImageSettings from "./TabData/ImageSettings";
import ImageDesign from "./TabData/ImageDesign";
import ImageFilters from "./TabData/ImageFilters";
import ImageWithFallback from "@/components/shared/image/ImageWithFallback";
import MediaGalleryModal from "@/components/media-store/GalleryModal/MediaGalleryModal";
import ApiCall from "@/api/api-calls";

const EditorImage = ({ toggleModal, modalName, type, lifecycleHandlers }) => {
  const { handleImageRemove, handleUpdateContainerContent } = useEditorImage({
    toggleModal,
    modalName,
    type,
  });

  const { state, selectedElement, setSelectedImage } = useDynamicManager(type);

  const content = state?.current?.content?.[0]?.content?.[0] ?? {};
  const [activeTab, setActiveTab] = useState(1);
  const [selectImageModal, showSelectImageModal] = useState(false);
  const [color, setColor] = useState(content?.imgBorderColor);
  const [overlayColor, setOverlayColor] = useState(content?.imgOverlayColor);
  const inputRefs = useRef([]);

  const submitEditorImage = useCallback(() => {
    const content = {
      type: "image",
      title: "Kép",
      image: state?.selectedImage || [],
      imgBorderColor: color,
      imgOverlayColor: overlayColor,
    };
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      if (ref) {
        if (ref.props) {
          // Handle cases where props contain value data
          if (Array.isArray(ref.props.value)) {
            // Handle arrays of values
            content[key] = ref.props.value.map((item) => item.value);
          } else {
            // Handle single values
            content[key] = ref.props.value?.value ?? "";
          }
        } else {
          // Handle cases where ref itself holds value data
          content[key] = ref?.value ?? "";
        }
      }
    });
    console.log("content", content);
    selectedElement({
      content: content,
    });

    handleUpdateContainerContent();
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
    handleImageRemove();
  }, [
    state,
    color,

    overlayColor,
    inputRefs,
    handleImageRemove,
    handleUpdateContainerContent,
    modalName,
    selectedElement,
    toggleModal,
  ]);

  const generateSelectedImage = useCallback(() => {
    const i = 0;

    if (state?.selectedImage && state?.selectedImage?._id) {
      return state?.selectedImage?.props?.mimetype === "application/pdf" ? (
        <div
          className={`flex flex-col mr-2 mb-2 items-center border-1 w-full`}
          key={state?.selectedImage?._id}>
          {/* <MediaObject
            data={selectedImage}
            index={i}
            data-index={i}
            className={"w-full"}
            id={selectedImage?._id}
          /> */}
          <p className="break-all p-1">
            {" "}
            {state?.selectedImage?.props?.basename ??
              state?.selectedImage?.originalname}
          </p>
          <input
            type="hidden"
            name="selectedFile"
            defaultValue={state?.selectedImage}
          />

          <button onClick={handleImageRemove} className="text-red-500 my-4">
            Eltávolítás
          </button>
        </div>
      ) : (
        <div
          className={`flex flex-col mr-2 mb-2 items-center border-1 w-full`}
          key={i}>
          <ImageWithFallback
            src={ApiCall.mediaStore.getResized(
              "/4/4/1",
              state?.selectedImage?.originalname
            )}
            width={150}
            height={100}
            alt={state?.selectedImage?.originalname ?? ""}
            effect="blur"
            loading="lazy"
          />
          <p className="break-all p-1">
            {state?.selectedImage?.props?.filename}
          </p>
          <input
            type="hidden"
            name="selectedFile"
            defaultValue={state?.selectedImage}
          />
          <button onClick={handleImageRemove}>Eltávolítás</button>
        </div>
      );
    }
  }, [state]);

  const tabData = [
    { id: 1, tabTitle: "Kép beállítások" },
    { id: 2, tabTitle: "Kép design" },
    { id: 3, tabTitle: "Filterek" },
  ];
  const handleTabClick = (tabNumber) => {
    setActiveTab(tabNumber);
  };
  const addRef = (key, ref) => {
    if (ref) {
      inputRefs.current[key] = ref; // Add or update the ref
    }
  };

  return (
    <div className="relative">
      {content && (
        <div className="image-wrapper flex flex-col w-full p-4">
          <TabSwitcher
            data={tabData}
            activeTab={activeTab}
            onTabClick={handleTabClick}
            type={type}
          />
          <div className={`w-full ${activeTab !== 1 ? "hidden" : ""}`}>
            <ImageSettings
              addRef={addRef}
              generateSelectedImage={generateSelectedImage}
              showSelectImageModal={showSelectImageModal}
              type={type}
            />
          </div>
          <div className={`w-full ${activeTab !== 2 ? "hidden" : ""}`}>
            <ImageDesign
              addRef={addRef}
              color={color}
              setColor={setColor}
              overlayColor={overlayColor}
              setOverlayColor={setOverlayColor}
              type={type}
            />
          </div>
          <div className={`w-full ${activeTab !== 3 ? "hidden" : ""}`}>
            <ImageFilters addRef={addRef} type={type} />
          </div>
        </div>
      )}

      <ModalButton btntext={"Mentés"} callback={submitEditorImage} />
      {/* image modal */}
      <MediaGalleryModal
        isOpen={selectImageModal}
        onClose={() => showSelectImageModal(false)}
        action="editorImage"
        onConfirmSelection={(selectedImages) =>
          setSelectedImage({ selectedImage: selectedImages })
        }
      />
    </div>
  );
};

export default EditorImage;
