import React, { useEffect, useState, useCallback } from "react";
import DataTableBase from "@/components/shared/datatable/DataTableBase";
import { useRouter } from "next/router";
import TableSelectOptions from "@/components/shared/datatable/TableSelectOptions";
import TableOptions from "@/components/shared/datatable/TableOptions";
import { useSelector, useDispatch } from "react-redux";
import { selectSingleForm } from "@/store/slices/pageEditorSlice";

const SelectProductList = ({
  tableTitle,
  data,
  token,
  columns,
  tableSelectOptionsList,
  paginationTotalRows,
  defaultSortFieldId,
  paginationPerPage,
  onSort,
  onChangePage,
  onChangeRowsPerPage,
  onSearch,
  isExpandableRow,
  conditionalCellStyles,
  paginationDefaultPage,
  orderdata,
  showSelectFormModal,
}) => {
  const [tableData, setTableData] = useState([]);
  const [selectedRows, setSelectedRows] = useState([]);
  const [toggleCleared, setToggleCleared] = useState(false);
  const [filteredText, setFilteredText] = useState("");
  const [resetPaginationToggle, setResetPaginationToggle] = useState(false);
  // const navigate = useRouter();
  const dispatch = useDispatch();

  // set current table data
  useEffect(() => {
    setTableData(data.tableData);
  }, [data]);

  // handle row selection
  const handleRowSelected = useCallback((state) => {
    setSelectedRows(state.selectedRows);
  }, []);

  const handleSearch = (event) => {
    setFilteredText(event.target.value);
    onSearch(event.target.value);
  };
  // store context actions in usememo
  const contextActions = React.useMemo(() => {
    const handleSelect = async () => {
      dispatch(selectSingleForm({ form: selectedRows[0] }));
      setSelectedRows([]);
      showSelectFormModal(false);
    };

    return (
      <TableSelectOptions
        data={tableSelectOptionsList}
        selectedRows={selectedRows}
        handleSelect={handleSelect}
      />
    );
  }, [tableData, selectedRows, toggleCleared]);

  // store subheader data in usememo
  const subHeaderComponentMemo = React.useMemo(() => {
    const handleClear = () => {
      if (filteredText) {
        setResetPaginationToggle(!resetPaginationToggle);
        setFilteredText("");
        onSearch("");
      }
    };

    return (
      <TableOptions
        onFilter={handleSearch}
        onClear={handleClear}
        filteredText={filteredText}
      />
    );
  }, [filteredText, resetPaginationToggle]);

  // render custom data-table component
  return (
    <DataTableBase
      title={tableTitle}
      data={tableData}
      orderdata={orderdata}
      columns={columns}
      tableSelectOptions={tableSelectOptionsList}
      paginationTotalRows={paginationTotalRows}
      paginationPerPage={paginationPerPage}
      selectableRows
      contextActions={contextActions}
      onSelectedRowsChange={handleRowSelected}
      clearSelectedRows={toggleCleared}
      onClearSelected={toggleCleared}
      paginationResetDefaultPage={resetPaginationToggle}
      subHeader
      subHeaderComponent={subHeaderComponentMemo}
      defaultSortFieldId={defaultSortFieldId}
      defaultSortAsc={true}
      onSort={onSort}
      onChangePage={onChangePage}
      onChangeRowsPerPage={onChangeRowsPerPage}
      isExpandableRow={isExpandableRow}
      conditionalCellStyles={conditionalCellStyles}
      paginationDefaultPage={paginationDefaultPage}
    />
  );
};

export default SelectProductList;
