import React, { useEffect, useState, useCallback, useRef } from "react";
import { useSelector, useDispatch } from "react-redux";
import Button from "@/components/shared/button/Button";
import dynamic from "next/dynamic";
import Modal from "@/components/shared/modal/Modal";
import FormList from "./FormList";
import {
  selectedElement,
  updateContainerContent,
  selectSingleForm,
} from "@/store/slices/pageEditorSlice";

const EditorSingleForm = ({ toggleModal, modalName }) => {
  const dispatch = useDispatch();
  const [selectFormModal, showSelectFormModal] = useState(false);

  const selectedForm = useSelector((state) => state.pageEditor.selectedForm);
  const editableContent = useSelector(
    (state) => state.pageEditor.current.content
  );
  const inputRefs = useRef([]);
  let index = 0;

  useEffect(() => {
    dispatch(
      selectSingleForm({
        form: editableContent?.[0]?.content?.[0]?.selectedForm,
      })
    );
  }, [editableContent]);

  const generateSelectedForm = useCallback(() => {
    return (
      <div className="flex flex-col justify-center items-center">
        <h5>
          <span className="font-semibold">Azonosító:</span>{" "}
          {editableContent?.[0]?.content?.[0]?.selectedForm
            ? editableContent?.[0]?.content?.[0]?.selectedForm?._id
            : selectedForm?._id}
        </h5>
        <h5>
          <span className="font-semibold">Form név:</span>{" "}
          {editableContent?.[0]?.content?.[0]?.selectedForm
            ? editableContent?.[0]?.content?.[0]?.selectedForm?.formTitle
            : selectedForm?.formTitle}
        </h5>
      </div>
    );
  }, [editableContent, selectedForm]);

  const submitForm = useCallback(() => {
    const content = {
      type: "single-form",
      title: "Űrlap",
      selectedForm: selectedForm,
    };

    inputRefs.current.map((c, i) => {
      if (c) {
        if (c.props) {
          if (Array.isArray(c.props.value)) {
            content[c.props.name] = c.props.value?.[0].value;
          } else {
            content[c.props.name] = c.props.value.value;
          }
        } else {
          content[c.name] = c.value;
        }
      }
    });

    dispatch(
      selectedElement({
        content: content,
      })
    );
    dispatch(updateContainerContent());
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
  }, [selectedForm, inputRefs]);

  return (
    <div className="relative">
      <div className="single-form-wrapper flex flex-col w-auto p-4">
        {/* select form */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"formSelect"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Form kiválasztása: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válasszon ki egy formot!
            </span>
          </label>
          <div className="flex flex-row w-3/4 justify-end items-center">
            {generateSelectedForm()}
          </div>
          <div className="flex flex-row w-3/4 justify-end items-center">
            <Button
              onClick={() => showSelectFormModal(true)}
              className=" border border-gray-300 px-4 py-2 text-gray-500 hover:border-gray-600 hover:text-gray-900"
              btntext="Form kiválasztása"></Button>
          </div>
        </div>
      </div>
      <div className="flex flex-row w-auto justify-end sticky bottom-0 bg-white p-2 border border-t">
        <Button
          onClick={submitForm}
          className="px-4 py-2 uppercase border bg-green-500/75 text-white hover:border-green-500 hover:bg-green-500 disabled:bg-gray-500 disabled:pointer-events-none"
          btntext="Mentés"
          // disabled={!isValid}
        />
      </div>
      <Modal
        title={"Form lista"}
        show={selectFormModal}
        onClose={() => showSelectFormModal(false)}>
        <FormList showSelectFormModal={showSelectFormModal} />
      </Modal>
    </div>
  );
};

export default EditorSingleForm;
