import React, { useEffect, useRef } from "react";
import SelectInput from "@/components/shared/selectinput/SelectInput";

const LinkSettings = ({ editableContent, addRef }) => {
  const inputRefs = useRef([]);

  useEffect(() => {
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });
  return (
    <div className={`w-full `}>
      {/* link */}
      {/* url */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"linkUrl"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Link megadása: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Ha szeretné, hogy a dobozra kattintás más oldalra mutasson, adjon
            meg linket. A link megadása nem kötelező.
          </span>
        </label>

        <input
          type="text"
          name="linkUrl"
          id="linkUrl"
          ref={(r) => (inputRefs.current[index++] = r)}
          className="w-3/4 border h-max p-2"
          defaultValue={editableContent?.[0]?.content?.[0]?.linkUrl ?? ""}
        />
      </div>
      {/* link target */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"boxLinkTarget"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Link célpontja: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Ha megadott linket, ezen érték alapján nyílik a link célpontja.
            (alapértelmezett: Másik oldalt nyit a link)
          </span>
        </label>
        <SelectInput
          options={initialData.linkTarget}
          className="w-3/4"
          menuPosition={"fixed"}
          placeholder={"Válasszon link célt"}
          backspaceRemovesValue={false}
          name={"boxLinkTarget"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.boxLinkTarget
              ? initialData?.linkTarget?.filter(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]?.boxLinkTarget
                )
              : initialData?.linkTarget[1]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
            // dispatch(selectParentPage({ parent: val }));
          }}
          required
        />
      </div>
      {/* link title text */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"linkTitle"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Link title szöveg megadása: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Ha szeretné, hogy a dobozra mutatásra jelenljen meg szöveg, itt
            tudja megadni.
          </span>
        </label>

        <input
          type="text"
          name="linkTitle"
          id="linkTitle"
          ref={(r) => (inputRefs.current[index++] = r)}
          className="w-3/4 border h-max p-2"
          defaultValue={editableContent?.[0]?.content?.[0]?.linkTitle ?? ""}
        />
      </div>
    </div>
  );
};

export default LinkSettings;
