import React, { useRef, useEffect } from "react";
import Image from "next/image";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import TextInput from "@/components/shared/textinput/TextInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import ApiCall from "@/api/api-calls";
import { initialData } from "@/data/data";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";

const ImageSettings = ({ editableContent, addRef }) => {
  const inputRefs = useRef([]);

  useEffect(() => {
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });
  return (
    <div className={`w-full`}>
      {/* image type: image / background */}
      <LabeledInput
        label="Kép típusa:"
        description=" Válassza ki, hogy Kép vagy Háttérkép elemet szeretne hozzáadni
            (alapértelmezett: Kép)">
        <SelectInput
          name="imageType"
          options={initialData.imageTypes}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.imageType
              ? initialData.imageTypes.filter(
                  (x) =>
                    x.value === editableContent?.[0]?.content?.[0]?.imageType
                )
              : initialData.imageTypes[0]
          }
          placeholder="Kép típusa"
          ref={(r) => {
            inputRefs.current.imageType = r;
          }}
        />
      </LabeledInput>
      {/* image layer */}
      <LabeledInput
        label="Kép layer:"
        description=" Megadhatja, hogy a kép fölött legyen-e egy layer. (alapértelmezett:
            Nincs layer a képen)">
        <SelectInput
          name="imageLayers"
          options={initialData.hasLayer}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.imageLayers
              ? initialData.hasLayer.filter(
                  (x) =>
                    x.value === editableContent?.[0]?.content?.[0]?.imageLayers
                )
              : initialData.hasLayer[0]
          }
          placeholder="Kép layer"
          ref={(r) => {
            inputRefs.current.imageLayers = r;
          }}
        />
      </LabeledInput>
      {/* image layer color */}
      <LabeledInput
        label={"Kép layer színe:"}
        description={
          "Válassza ki, hogy milyen színű legyen a kép előtti layer - (alapértelmezett érték:rgba(33, 33, 33, 0.5))."
        }>
        <ColorPickerComponent
          name={"imageOverlayColor"}
          value={imageOverlayColor}
          onChange={setImageOverlayColor}
        />
      </LabeledInput>
      {/* image position */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"imageBackgroundPosition"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Kép pozíciója: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki a háttér megjelenítése pozícióját. Csak abban az esetben
            érvényesül, ha a kép típusa: Háttérkép (alapértelmezett: Inherit -
            Örökölt)
          </span>
        </label>

        <SelectInput
          options={initialData.editor.image.imageBackgroundPosition}
          className="w-3/4"
          menuPosition={"fixed"}
          placeholder={"Válasszon háttér pozíciót"}
          backspaceRemovesValue={false}
          name={"imageBackgroundPosition"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.imageBackgroundPosition
              ? initialData?.editor?.image?.imageBackgroundPosition?.filter(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]?.imageBackgroundPosition
                )
              : initialData?.editor?.image?.imageBackgroundPosition[0]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
            // dispatch(selectParentPage({ parent: val }));
          }}
          required
        />
      </div>
      {/* image object fit */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"imageObjectFit"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Kép objektum illeszkedése: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy a képet tartalmazó dobozban hogyan viselkedjen a
            kép. Alapértelmezett: Cover (Kitölti a teljes doboz méretet)
          </span>
        </label>
        <SelectInput
          options={initialData.editor.image.imageObjectFit}
          className="w-3/4"
          menuPosition={"fixed"}
          placeholder={"Válasszon háttér pozíciót"}
          backspaceRemovesValue={false}
          name={"imageObjectFit"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.imageObjectFit
              ? initialData?.editor?.image?.imageObjectFit.filter(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]?.imageObjectFit
                )
              : initialData?.editor?.image?.imageObjectFit[1]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
            // dispatch(selectParentPage({ parent: val }));
          }}
          required
        />
      </div>
      {/* image object position */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"imageObjectPosition"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Kép objektum pozíciója: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy a kép melyik részére fókuszáljon a dobozban.
            Alapértelmezett: Center (A kép közepe kerül fókuszba)
          </span>
        </label>
        <SelectInput
          options={initialData?.editor?.image?.imageObjectPosition}
          className="w-3/4"
          menuPosition={"fixed"}
          placeholder={"Válasszon háttér pozíciót"}
          backspaceRemovesValue={false}
          name={"imageObjectPosition"}
          ref={(r) => (inputRefs.current[index++] = r)}
          isMulti
          defaultValue={
            editableContent?.[0]?.content?.[0]?.imageObjectPosition
              ? initialData?.editor?.image?.imageObjectPosition?.filter((x) =>
                  editableContent?.[0]?.content?.[0]?.imageObjectPosition?.includes(
                    x.value
                  )
                )
              : initialData?.editor?.image?.imageObjectPosition[1]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
            // dispatch(selectParentPage({ parent: val }));
          }}
          required
        />
      </div>
      {/* image max height */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"imgMaxHeight"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">
            Kép maximális magasságának megadása:{" "}
          </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Adja meg a kép maximális magasságát. A megjelenítéskor ez az érték
            lesz a kép maximális magassága a megadott mértékegységgel (pl.: px,
            vh, em, rem). Alapértelmezett: 0
          </span>
        </label>
        <div className="w-3/4 flex flex-row flex-nowrap justify-between">
          <input
            type="text"
            name="imgMaxHeight"
            id="imgMaxHeight"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-1/2 border h-max p-2"
            defaultValue={editableContent?.[0]?.content?.[0]?.imgMaxHeight ?? 0}
          />
        </div>
      </div>
      {/* image dimensions */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"altText"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Kép dimenziójának megadása: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Adjon meg aránypárt, amely alapján a kép generálódik. Az itt
            megadott érték (*100) lesz a kép pixelben megadott szélessége és
            magassága (pl.: 16:9 - 1600px:900px méretű kép generálódik).
            Alapértelmezett: 4:3
          </span>
        </label>
        <div className="w-3/4 flex flex-row flex-nowrap justify-between">
          <input
            type="number"
            name="imgWidth"
            id="imgWidth"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-1/2 border h-max p-2"
            defaultValue={editableContent?.[0]?.content?.[0]?.imgWidth ?? 4}
          />
          <input
            type="number"
            name="imgHeight"
            id="imgHeight"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-1/2 border h-max p-2"
            defaultValue={editableContent?.[0]?.content?.[0]?.imgHeight ?? 3}
          />
        </div>
      </div>
      {/* image cut to size */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"imageCutToSize"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Kép vágása: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy a kép vágva legyen-e a megadott arányra.
            Alapértelmezett: Igen
          </span>
        </label>
        <SelectInput
          options={initialData?.editor?.image?.imageCutToSize}
          className="w-3/4"
          menuPosition={"fixed"}
          placeholder={"Válasszon háttér pozíciót"}
          backspaceRemovesValue={false}
          name={"imageCutToSize"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.imageCutToSize
              ? initialData?.editor?.image?.imageCutToSize?.filter(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]?.imageCutToSize
                )
              : initialData?.editor?.image?.imageCutToSize[0]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
            // dispatch(selectParentPage({ parent: val }));
          }}
          required
        />
      </div>
      {/* image quality */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"altText"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Képminőség megadása: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Adjon meg képminőséget. Százalékos értékben adja meg, % jel nélkül.
            Alapértelmezett: 100
          </span>
        </label>
        <input
          type="number"
          name="imgQuality"
          id="imgQuality"
          ref={(r) => (inputRefs.current[index++] = r)}
          className="w-3/4 border h-max p-2"
          defaultValue={editableContent?.[0]?.content?.[0]?.imgQuality ?? 100}
        />
      </div>
      {/* alt text */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"altText"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Képleírás - alt text - megadása: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Adjon meg képleírást. Ez a szöveg csak a keresőrobotok és a
            szövegolvasó alkalmazások számára látható.
          </span>
        </label>
        <input
          type="text"
          name="altText"
          id="altText"
          ref={(r) => (inputRefs.current[index++] = r)}
          className="w-3/4 border h-max p-2"
          defaultValue={editableContent?.[0]?.content?.[0]?.altText ?? ""}
        />
      </div>
      {/* image radius */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"imageRadius"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Kép lekerekítésének értéke: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy a kép elemnek legyen-e lekerekítése.
            Alapértelmezett: 0. Lehetséges értékek: %, unset, px, vh, rem, em
          </span>
        </label>
        <div className="flex flex-row flex-nowrap justify-evenly items-center">
          <div className="flex flex-row flex-nowrap w-3/4 justify-evenly items-center max-h-10">
            <input
              type="text"
              name="imageRadius"
              id="imageRadius"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.imageRadius ?? 0
              }
            />
          </div>
        </div>
      </div>
      {/* image border size */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"imageBorder"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Kép keretének mérete: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy a kép elemnek milyen vastag kerete legyen px-ben.
            Alapértelmezett: 0
          </span>
        </label>
        <div className="flex flex-row flex-nowrap justify-evenly items-center">
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
            <input
              type="text"
              name="imageBorderTop"
              id="imageBorderTop"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.imageBorderTop ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600  w-[2rem] h-[2rem]">
              {icons.right}
            </span>
            <input
              type="text"
              name="imageBorderRight"
              id="imageBorderRight"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.imageBorderRight ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.down}
            </span>
            <input
              type="text"
              name="imageBorderBottom"
              id="imageBorderBottom"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.imageBorderBottom ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.left}
            </span>
            <input
              type="text"
              name="imageBorderLeft"
              id="imageBorderLeft"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.imageBorderLeft ?? 0
              }
            />
          </div>
        </div>
      </div>
      {/* image border style */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"imageBorderStyle"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Kép keret stílusa: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy milyen stílusa legyen a kép keretnek.
            Alapértelmezett: solid
          </span>
        </label>
        <SelectInput
          options={initialData.borderStyle}
          className="w-3/4"
          menuPosition={"fixed"}
          placeholder={"Kép keret stílusa"}
          backspaceRemovesValue={false}
          name={"imageBorderStyle"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.imageBorderStyle
              ? initialData.borderStyle.filter(
                  (x) =>
                    x.value ===
                    editableContent?.[0].content[0]?.imageBorderStyle
                )
              : initialData.borderStyle[2]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
          }}
          required
        />
      </div>
      {/* image border color */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"imageBorderColor"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Kép keret színének beállítása: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy milyen színű legyen a kép kerete. Alapértelmezett:
            #ffffff
          </span>
        </label>
        <div className="w-3/4 flex flex-row justify-center align-center">
          <ColorPickerComponent
            value={imageBorderColor}
            onChange={setImageBorderColor}
          />
        </div>
      </div>
      {/* image background color */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"imageBackgroundColor"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Kép háttér színének beállítása: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy milyen színű legyen a kép háttere. Alapértelmezett:
            átlátszó
          </span>
        </label>
        <div className="w-3/4 flex flex-row justify-center align-center">
          <ColorPickerComponent
            value={imageBackgroundColor}
            onChange={setImageBackgroundColor}
          />
        </div>
      </div>
    </div>
  );
};

export default ImageSettings;
