import React, { useRef, useEffect } from "react";
import Image from "next/image";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import TextInput from "@/components/shared/textinput/TextInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import ApiCall from "@/api/api-calls";
import { initialData } from "@/data/data";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import IconList from "@/components/shared/icon/IconList";

const IconSettings = ({ editableContent, addRef }) => {
  const inputRefs = useRef([]);

  useEffect(() => {
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });

  return (
    <div className={`w-full`}>
      {/* icon padding */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconPadding"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Ikon eltartás: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy az ikon elemnek mekkora eltartása legyen px-ben.
            Alapértelmezett: 0 0 0 0
          </span>
        </label>

        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
          <input
            type="text"
            name="iconPaddingTop"
            id="iconPaddingTop"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.iconPaddingTop ?? 0
            }
          />
        </div>
        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.right}</span>
          <input
            type="text"
            name="iconPaddingRight"
            id="iconPaddingRight"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.iconPaddingRight ?? 0
            }
          />
        </div>
        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.down}</span>
          <input
            type="text"
            name="iconPaddingBottom"
            id="iconPaddingBottom"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.iconPaddingBottom ?? 0
            }
          />
        </div>
        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.left}</span>
          <input
            type="text"
            name="iconPaddingLeft"
            id="iconPaddingLeft"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.iconPaddingLeft ?? 0
            }
          />
        </div>
      </div>
      {/* icon margin */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconMargin"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Ikon margin: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy az ikon elemnek mekkora marginja legyen px-ben.
            Alapértelmezett: 0 0 0 0
          </span>
        </label>

        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
          <input
            type="text"
            name="iconMarginTop"
            id="iconMarginTop"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.iconMarginTop ?? 0
            }
          />
        </div>
        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.right}</span>
          <input
            type="text"
            name="iconMarginRight"
            id="iconMarginRight"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.iconMarginRight ?? 0
            }
          />
        </div>
        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.down}</span>
          <input
            type="text"
            name="iconMarginBottom"
            id="iconMarginBottom"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.iconMarginBottom ?? 0
            }
          />
        </div>
        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.left}</span>
          <input
            type="text"
            name="iconMarginLeft"
            id="iconMarginLeft"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.iconMarginLeft ?? 0
            }
          />
        </div>
      </div>
      {/* icon fill color */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconFillColor"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Ikon kitöltési szín: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy milyen színnel legyen kitöltve az ikon -
            (alapértelmezett érték: #eeeeee - szürke).
          </span>
        </label>
        <div className="w-3/4 flex flex-row justify-center align-center">
          <ColorPickerComponent
            value={iconFillColor}
            onChange={setIconFillColor}
          />
        </div>
      </div>
      {/* icon background */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconBackgroundColor"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Ikon háttér szín: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy milyen színű legyen az ikon háttere -
            (alapértelmezett érték: #fff - Fehér).
          </span>
        </label>

        <div className="w-3/4 flex flex-row justify-center align-center">
          <ColorPickerComponent
            value={iconBackgroundColor}
            onChange={setIconBackgroundColor}
          />
        </div>
      </div>
      {/* icon size */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconSize"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Ikon méret értéke: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy az ikon mekkora méretben jelenjen meg.
            Alapértelmezett: 72. Lehetséges értékek: 0-100
          </span>
        </label>
        <div className="flex flex-row flex-nowrap justify-evenly items-center">
          <div className="flex flex-row flex-nowrap w-3/4 justify-evenly items-center max-h-10">
            <input
              type="number"
              name="iconSize"
              id="iconSize"
              min={0}
              max={100}
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              onChange={(e) => handleInputMinMax(e)}
              defaultValue={editableContent?.[0]?.content?.[0]?.iconSize ?? 72}
            />
          </div>
        </div>
      </div>
      {/* icon separator design*/}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"separatorDesign"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Elválasztó stílusa: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy milyen stílusa legyen az elválasztónak.
            Alapértelmezett: None
          </span>
        </label>
        <SelectInput
          options={initialData.editor.separator.separatorDesign}
          className="w-3/4"
          menuPosition={"fixed"}
          placeholder={"Elválasztó stílusa"}
          backspaceRemovesValue={false}
          name={"separatorDesign"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.separatorDesign
              ? initialData.editor.separator.separatorDesign.filter(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]?.separatorDesign
                )
              : initialData.editor.separator.separatorDesign[8]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
          }}
          required
        />
      </div>
      {/* icon separator backgroundcolor */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"backgroundColor"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">
            Elválasztó háttér színének kiválasztása:{" "}
          </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy milyen színű legyen az elválasztó háttere.
            Alapértelmezett: transparent
          </span>
        </label>
        <ColorPickerComponent
          value={iconSeparatorBackgroundColor}
          onChange={setIconSeparatorBackgroundColor}
        />
      </div>
      {/* separator width % - default 100 */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"separatorWidth"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Elválasztó szélessége: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Elválasztó szélességének beállítása. 0-100-ig választható érték
            %-ban. Alapértelmezett: 100
          </span>
        </label>

        <input
          type="number"
          min={0}
          max={100}
          name="separatorWidth"
          id="separatorWidth"
          ref={(r) => (inputRefs.current[index++] = r)}
          onChange={(e) => handleInputMinMax(e)}
          className="w-3/4 border h-max p-2"
          defaultValue={
            editableContent?.[0]?.content?.[0]?.separatorWidth ?? 100
          }
        />
      </div>
      {/* separator height - default 0 */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"separatorHeight"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Elválasztó magassága: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Elválasztó magasságának beállítása. Px, vh, vw, %, stb.
            Alapértelmezett: 0
          </span>
        </label>

        <input
          type="text"
          name="separatorHeight"
          id="separatorHeight"
          ref={(r) => (inputRefs.current[index++] = r)}
          className="w-3/4 border h-max p-2"
          defaultValue={
            editableContent?.[0]?.content?.[0]?.separatorHeight ?? 0
          }
        />
      </div>
      {/* separator vastagsága px - default 0 */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"separatorThickness"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Elválasztó vonal vastagsága: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Elválasztó vonal vastagságának beállítása. 0-100-ig választható
            érték px-ben. Alapértelmezett: 0
          </span>
        </label>

        <input
          type="number"
          min={0}
          max={100}
          name="separatorThickness"
          id="separatorThickness"
          ref={(r) => (inputRefs.current[index++] = r)}
          onChange={(e) => handleInputMinMax(e)}
          className="w-3/4 border h-max p-2"
          defaultValue={
            editableContent?.[0]?.content?.[0]?.separatorThickness ?? 0
          }
        />
      </div>
      {/* separator position: left - center - right */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"separatorPosition"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Elválasztó pozíciója: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy milyen pozícióban legyen az elválasztó.
            Alapértelmezett: Közép
          </span>
        </label>
        <SelectInput
          options={initialData.editor.separator.separatorPosition}
          className="w-3/4"
          menuPosition={"fixed"}
          placeholder={"Elválasztó pozíciója"}
          backspaceRemovesValue={false}
          name={"separatorPosition"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.separatorPosition
              ? initialData.editor.separator.separatorPosition.filter(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]?.separatorPosition
                )
              : initialData.editor.separator.separatorPosition[1]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
          }}
          required
        />
      </div>
      {/* separator position: left - center - right */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconSeparatorBorderPosition"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">
            Elválasztó megjelenítési pozíciója:{" "}
          </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy az ikon melyik oldalán jelenjen meg az elválasztó.
            Alapértelmezett: Alul
          </span>
        </label>
        <SelectInput
          options={initialData.borderPositions}
          className="w-3/4"
          menuPosition={"fixed"}
          placeholder={"Elválasztó pozíciója"}
          backspaceRemovesValue={false}
          name={"iconSeparatorBorderPosition"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.iconSeparatorBorderPosition
              ? initialData.borderPositions.filter(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]
                      ?.iconSeparatorBorderPosition
                )
              : initialData.borderPositions[2]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
          }}
          required
        />
      </div>
      {/* separator padding top - bottom */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"textDistance"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Elválasztó eltartása: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy az elválasztó milyen padding értéket vegyen fel a
            doboz tetejétől és aljától - (alapértelmezett érték: 0 0).
          </span>
        </label>
        <div className="flex flex-row flex-nowrap justify-evenly items-center">
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
            <input
              type="number"
              name="separatorPositionTop"
              id="separatorPositionTop"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.separatorPositionTop ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.right}
            </span>
            <input
              type="number"
              name="separatorPositionRight"
              id="separatorPositionRight"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.separatorPositionRight ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.down}
            </span>
            <input
              type="number"
              name="separatorPositionBottom"
              id="separatorPositionBottom"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.separatorPositionBottom ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.left}
            </span>
            <input
              type="number"
              name="separatorPositionLeft"
              id="separatorPositionLeft"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.separatorPositionLeft ?? 0
              }
            />
          </div>
        </div>
      </div>
      {/* separator color */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"separatorColor"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Elválasztó színének kiválasztása: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy milyen színű legyen az elválasztó. Alapértelmezett:
            #212121
          </span>
        </label>
        <ColorPickerComponent
          value={iconSeparatorColor}
          onChange={setIconSeparatorColor}
        />
      </div>
      {/* icon border radius */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconRadius"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">
            Ikon keret lekerekítésének értéke:{" "}
          </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy az ikon keretnek legyen-e lekerekítése.
            Alapértelmezett: 0. Lehetséges értékek: %, unset, px, vh, rem, em
          </span>
        </label>
        <div className="flex flex-row flex-nowrap justify-evenly items-center">
          <div className="flex flex-row flex-nowrap w-3/4 justify-evenly items-center max-h-10">
            <input
              type="text"
              name="iconRadius"
              id="iconRadius"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={editableContent?.[0]?.content?.[0]?.iconRadius ?? 0}
            />
          </div>
        </div>
      </div>
      {/* icon border size */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconBorder"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Ikon keretének mérete: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy az ikon elemnek milyen vastag kerete legyen px-ben.
            Alapértelmezett: 0
          </span>
        </label>
        <div className="flex flex-row flex-nowrap justify-evenly items-center">
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
            <input
              type="text"
              name="iconBorderTop"
              id="iconBorderTop"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.iconBorderTop ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600  w-[2rem] h-[2rem]">
              {icons.right}
            </span>
            <input
              type="text"
              name="iconBorderRight"
              id="iconBorderRight"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.iconBorderRight ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.down}
            </span>
            <input
              type="text"
              name="iconBorderBottom"
              id="iconBorderBottom"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.iconBorderBottom ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.left}
            </span>
            <input
              type="text"
              name="iconBorderLeft"
              id="iconBorderLeft"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.iconBorderLeft ?? 0
              }
            />
          </div>
        </div>
      </div>
      {/* box border style */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconBorderStyle"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Ikon keret stílusa: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy milyen stílusa legyen az ikon keretnek.
            Alapértelmezett: solid
          </span>
        </label>
        <SelectInput
          options={initialData.borderStyle}
          className="w-3/4"
          menuPosition={"fixed"}
          placeholder={"Doboz keret stílusa"}
          backspaceRemovesValue={false}
          name={"iconBorderStyle"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.iconBorderStyle
              ? initialData.borderStyle.filter(
                  (x) =>
                    x.value === editableContent?.[0].content[0]?.iconBorderStyle
                )
              : initialData.borderStyle[2]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
          }}
          required
        />
      </div>
      {/* icon border color */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconBorderColor"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Ikon keret színének beállítása: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy milyen színű legyen az ikon kerete.
            Alapértelmezett: #ffffff
          </span>
        </label>
        <div className="w-3/4 flex flex-row justify-center align-center">
          <ColorPickerComponent
            value={iconBorderColor}
            onChange={setIconBorderColor}
          />
        </div>
      </div>
      {/* icon border width % - default 100 */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconBorderWidth"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Icon keret szélessége: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Ikon keret szélességének beállítása. 0-100-ig választható érték
            %-ban. Alapértelmezett: 100
          </span>
        </label>

        <input
          type="number"
          min={0}
          max={100}
          name="iconBorderWidth"
          id="iconBorderWidth"
          ref={(r) => (inputRefs.current[index++] = r)}
          onChange={(e) => handleInputMinMax(e)}
          className="w-3/4 border h-max p-2"
          defaultValue={
            editableContent?.[0]?.content?.[0]?.iconBorderWidth ?? 100
          }
        />
      </div>
      {/* icon border height - default 100 */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconBorderHeight"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Ikon keret magassága: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Ikon keret magasságának beállítása. Px, vh, vw, %, stb.
            Alapértelmezett: 100
          </span>
        </label>

        <input
          type="text"
          name="iconBorderHeight"
          id="iconBorderHeight"
          ref={(r) => (inputRefs.current[index++] = r)}
          className="w-3/4 border h-max p-2"
          defaultValue={
            editableContent?.[0]?.content?.[0]?.iconBorderHeight ?? 100
          }
        />
      </div>
      {/* ikon keret position: left - center - right */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"iconBorderPosition"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Ikon keret pozíciója: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy milyen pozícióban legyen az ikon kerete.
            Alapértelmezett: Közép
          </span>
        </label>
        <SelectInput
          options={initialData.editor.separator.separatorPosition}
          className="w-3/4"
          menuPosition={"fixed"}
          placeholder={"Ikon keret pozíciója"}
          backspaceRemovesValue={false}
          name={"iconBorderPosition"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.iconBorderPosition
              ? initialData.editor.separator.separatorPosition.filter(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]?.iconBorderPosition
                )
              : initialData.editor.separator.separatorPosition[1]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
          }}
          required
        />
      </div>
    </div>
  );
};

export default IconSettings;
