import React, { useRef, useEffect } from "react";
import Image from "next/image";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import TextInput from "@/components/shared/textinput/TextInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import ApiCall from "@/api/api-calls";
import { initialData } from "@/data/data";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import icons from "@/assets/icons/icons";

const ContentBoxSettings = ({
  editableContent,
  addRef,
  boxBorderColor,
  setBoxBorderColor,
  boxBackgroundColor,
  setBoxBackgroundColor,
}) => {
  const inputRefs = useRef([]);

  useEffect(() => {
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });
  return (
    <div className={`w-full `}>
      {/* content box content order row/col */}
      <LabeledInput
        label="Oszlop tartalom elrendezés:"
        description="Válassza ki, hogy sor vagy oszlop legyen a tartalmi elrendezés.
            (alapértelmezett: Oszlop)">
        <SelectInput
          name="contentOrder"
          options={initialData.contentOrder}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.contentOrder
              ? initialData.contentOrder.find(
                  (x) =>
                    x.value === editableContent?.[0]?.content?.[0]?.contentOrder
                )
              : initialData.contentOrder[1]
          }
          placeholder="Oszlop tartalom elrendezés"
          ref={(r) => {
            inputRefs.current.contentOrder = r;
          }}
        />
      </LabeledInput>
      {/* order content on breakpoints */}
      <LabeledInput
        label="Oszlop tartalom elrendezés töréspontoknál:"
        description="Válassza ki, hogy sor vagy oszlop legyen a tartalmi elrendezés a megadott töréspontoknál.">
        <SelectInput
          name="orderBreakpoints"
          options={initialData.orderBreakpoints}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.orderBreakpoints
              ? initialData?.orderBreakpoints?.filter((x) =>
                  editableContent?.[0].content[0]?.orderBreakpoints?.includes(
                    x.value
                  )
                )
              : ""
          }
          placeholder="Oszlop tartalom elrendezés töréspontoknál"
          ref={(r) => {
            inputRefs.current.orderBreakpoints = r;
          }}
          isMulti
        />
      </LabeledInput>
      {/* content position X axis */}
      <LabeledInput
        label="Tartalom elhelyezkedése X tengelyen:"
        description=" Válassza ki, hogy az oszlopon belül milyen pozícióban helyezkedjenek
            el az elemek - (alapértelmezett érték: Center).">
        <SelectInput
          name="contentJustify"
          options={initialData.justify}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.contentJustify
              ? initialData.justify.filter(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]?.contentJustify
                )
              : initialData.justify[0]
          }
          placeholder="Tartalom elhelyezkedése X tengelyen"
          ref={(r) => {
            inputRefs.current.contentJustify = r;
          }}
        />
      </LabeledInput>
      {/* content position Y axis */}
      <LabeledInput
        label="Tartalom elhelyezkedése Y tengelyen:"
        description="Válassza ki, hogy az oszlopon belül milyen pozícióban helyezkedjenek
            el az elemek - (alapértelmezett érték: Center).">
        <SelectInput
          name="contentAlign"
          options={initialData.align}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.contentAlign
              ? initialData.align.filter(
                  (x) =>
                    x.value === editableContent?.[0]?.content?.[0]?.contentAlign
                )
              : initialData.align[1]
          }
          placeholder="Tartalom elhelyezkedése Y tengelyen"
          ref={(r) => {
            inputRefs.current.contentAlign = r;
          }}
        />
      </LabeledInput>
      {/* content overflow */}
      <LabeledInput
        label="Tartalom elhelyezkedése Y tengelyen:"
        description="Válassza ki, hogy az oszlopon belül milyen pozícióban helyezkedjenek
            el az elemek - (alapértelmezett érték: Center).">
        <SelectInput
          name="boxOverflow"
          options={initialData.overflow}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.boxOverflow
              ? initialData.overflow.filter(
                  (x) =>
                    x.value === editableContent?.[0]?.content?.[0]?.boxOverflow
                )
              : initialData.overflow[0]
          }
          placeholder="Tartalom elhelyezkedése Y tengelyen"
          ref={(r) => {
            inputRefs.current.boxOverflow = r;
          }}
        />
      </LabeledInput>
      {/* box height*/}
      <LabeledInput
        label={"Doboz magasság:"}
        description={
          "Megadhatja, hogy az elemnek mekkora magassága legyen. Alapértelmezett: inherit. Lehetséges értékek: auto, fit-content, inherit, initial, max-content, min-content, revert, unset, px, vh, rem, em"
        }>
        <p className="flex">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.down}</span>
        </p>
        <TextInput
          type={"text"}
          name={"boxHeight"}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.boxHeight ?? "inherit"
          }
          ref={(r) => (inputRefs.current.boxHeight = r)}
        />
      </LabeledInput>
      {/* box max height*/}
      <LabeledInput
        label={"Doboz maximum magasság:"}
        description={
          "Megadhatja, hogy az elemnek mekkora maximum magassága legyen. Alapértelmezett: inherit. Lehetséges értékek: auto, fit-content, inherit, initial, max-content, min-content, revert, unset, px, vh, rem, em"
        }>
        <p className="flex">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.down}</span>
        </p>
        <TextInput
          type={"text"}
          name={"boxMaxHeight"}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.boxMaxHeight ?? "inherit"
          }
          ref={(r) => (inputRefs.current.boxMaxHeight = r)}
        />
      </LabeledInput>
      {/* box margin */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"contentMargin"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Doboz margin: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy a doboznak mekkora marginja legyen px-ben.
            Alapértelmezett: 0
          </span>
        </label>

        <div className="flex flex-row flex-nowrap justify-evenly items-center">
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
            <input
              type="text"
              name="contentMarginTop"
              id="contentMarginTop"
              ref={(r) => (inputRefs.current.contentMarginTop = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.contentMarginTop ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.right}
            </span>
            <input
              type="text"
              name="contentMarginRight"
              id="contentMarginRight"
              ref={(r) => (inputRefs.current.contentMarginRight = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.contentMarginRight ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.down}
            </span>
            <input
              type="text"
              name="contentMarginBottom"
              id="contentMarginBottom"
              ref={(r) => (inputRefs.current.contentMarginBottom = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.contentMarginBottom ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.left}
            </span>
            <input
              type="text"
              name="contentMarginLeft"
              id="contentMarginLeft"
              ref={(r) => (inputRefs.current.contentMarginLeft = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.contentMarginLeft ?? 0
              }
            />
          </div>
        </div>
      </div>
      {/* box padding */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"contentPadding"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Doboz padding: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy a doboznak mekkora paddingja legyen px-ben.
            Alapértelmezett: 0
          </span>
        </label>

        <div className="flex flex-row flex-nowrap justify-evenly items-center">
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
            <input
              type="text"
              name="contentPaddingTop"
              id="contentPaddingTop"
              ref={(r) => (inputRefs.current.contentPaddingTop = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.contentPaddingTop ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.right}
            </span>
            <input
              type="text"
              name="contentPaddingRight"
              id="contentPaddingRight"
              ref={(r) => (inputRefs.current.contentPaddingRight = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.contentPaddingRight ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.down}
            </span>
            <input
              type="text"
              name="contentPaddingBottom"
              id="contentPaddingBottom"
              ref={(r) => (inputRefs.current.contentPaddingBottom = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.contentPaddingBottom ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.left}
            </span>
            <input
              type="text"
              name="contentPaddingLeft"
              id="contentPaddingLeft"
              ref={(r) => (inputRefs.current.contentPaddingLeft = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.contentPaddingLeft ?? 0
              }
            />
          </div>
        </div>
      </div>
      {/* box radius */}
      <LabeledInput
        label={"Doboz lekerekítésének mértéke:"}
        description={
          "Megadhatja, hogy a doboz elemnek legyen-e lekerekítése. Alapértelmezett: 0. Lehetséges értékek: %, unset, px, vh, rem, em"
        }>
        <TextInput
          type={"text"}
          name={"boxRadius"}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.boxRadius ?? "inherit"
          }
          ref={(r) => (inputRefs.current.boxRadius = r)}
        />
      </LabeledInput>
      {/* box border size */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"boxBorder"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Doboz keretének mérete: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy a oszlop elemnek milyen vastag kerete legyen
            px-ben. Alapértelmezett: 0
          </span>
        </label>
        <div className="flex flex-row flex-nowrap justify-evenly items-center">
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
            <input
              type="text"
              name="boxBorderTop"
              id="boxBorderTop"
              ref={(r) => (inputRefs.current.boxBorderTop = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.boxBorderTop ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600  w-[2rem] h-[2rem]">
              {icons.right}
            </span>
            <input
              type="text"
              name="boxBorderRight"
              id="boxBorderRight"
              ref={(r) => (inputRefs.current.boxBorderRight = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.boxBorderRight ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.down}
            </span>
            <input
              type="text"
              name="boxBorderBottom"
              id="boxBorderBottom"
              ref={(r) => (inputRefs.current.boxBorderBottom = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.boxBorderBottom ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.left}
            </span>
            <input
              type="text"
              name="boxBorderLeft"
              id="boxBorderLeft"
              ref={(r) => (inputRefs.current.boxBorderLeft = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.boxBorderLeft ?? 0
              }
            />
          </div>
        </div>
      </div>
      {/* box border style */}
      <LabeledInput
        label="Doboz keret stílusa:"
        description="Válassza ki, hogy az oszlopon belül milyen pozícióban helyezkedjenek
            el az elemek - (alapértelmezett érték: Center).">
        <SelectInput
          name="borderStyle"
          options={initialData.borderStyle}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.borderStyle
              ? initialData.borderStyle.filter(
                  (x) =>
                    x.value === editableContent?.[0]?.content?.[0]?.borderStyle
                )
              : initialData.borderStyle[2]
          }
          placeholder="Tartalom elhelyezkedése Y tengelyen"
          ref={(r) => {
            inputRefs.current.borderStyle = r;
          }}
        />
      </LabeledInput>
      {/* box border color */}
      <LabeledInput
        label={"Doboz keret színének beállítása:"}
        description={
          "Megadhatja, hogy milyen színű legyen a doboz kerete. Alapértelmezett: #ffffff"
        }>
        {" "}
        <ColorPickerComponent
          name={"boxBorderColor"}
          value={boxBorderColor}
          onChange={setBoxBorderColor}
        />
      </LabeledInput>

      {/* content box background color */}
      <LabeledInput
        label={"Doboz háttér színének beállítása:"}
        description={
          "Megadhatja, hogy milyen színű legyen a doboz háttér. Alapértelmezett: rgba(255, 255, 255, 1)"
        }>
        {" "}
        <ColorPickerComponent
          name={"boxBackgroundColor"}
          value={boxBackgroundColor}
          onChange={setBoxBackgroundColor}
        />
      </LabeledInput>
    </div>
  );
};

export default ContentBoxSettings;
