import React, { useState, useCallback } from "react";
import dynamic from "next/dynamic";
import "react-quill/dist/quill.snow.css";
import { useSelector, useDispatch } from "react-redux";
import Button from "@/components/shared/button/Button";
import {
  selectedElement,
  updateContainerContent,
} from "@/store/slices/pageEditorSlice";
import ModalButton from "@/components/shared/modal/ModalButton";

const SunEditor = dynamic(() => import("suneditor-react"), {
  ssr: false,
});

const Code = ({ toggleModal, modalName }) => {
  const editableContent = useSelector(
    (state) => state.pageEditor.current.content
  );

  const dispatch = useDispatch();
  const [codeContent, setCodeContent] = useState(
    editableContent?.[0]?.content?.[0]?.codeContent ?? ""
  );

  const submitCode = useCallback(() => {
    const content = {
      type: "code",
      title: "Kód",
      codeContent: codeContent,
    };

    dispatch(
      selectedElement({
        content: content,
      })
    );
    dispatch(updateContainerContent());
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
  }, [codeContent]);

  return (
    <div className="relative">
      <div className="code-wrapper flex flex-col w-full p-4">
        {/* codeContent */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"codeContent"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap  pr-2">
            <p className="w-full font-bold">Kód: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Adjon meg tartalmat.
            </span>
          </label>
          <SunEditor
            lang="en"
            name="codeContent"
            defaultValue={codeContent}
            width="100%"
            height="100%"
            placeholder="Ide gépelheti a szöveget..."
            autoFocus={false}
            onChange={(value) => setCodeContent(value)}
            setOptions={{
              buttonList: [
                ["font", "fontSize", "formatBlock"],
                [
                  "bold",
                  "underline",
                  "italic",
                  "strike",
                  "subscript",
                  "superscript",
                ],
                ["align", "list", "table"],
                ["fontColor", "hiliteColor"],
                ["outdent", "indent"],
                ["undo", "redo"],
                ["removeFormat"],
                ["link", "image"],
                ["preview", "print"],
                ["fullScreen", "showBlocks", "codeView"],
              ],
              tableWidth: "100%",
              tableStyles: {
                border: "1px solid black",
              },
            }}
          />
        </div>
      </div>
      <ModalButton btntext={"Mentés"} callback={submitCode} />
    </div>
  );
};

export default Code;
