import React, { useRef, useEffect } from "react";
import Image from "next/image";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import TextInput from "@/components/shared/textinput/TextInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import ApiCall from "@/api/api-calls";
import { initialData } from "@/data/data";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import { handleInputMinMax } from "@/utils/handleInputMinMax";
import icons from "@/assets/icons/icons";

const ButtonSettings = ({ editableContent, addRef }) => {
  const inputRefs = useRef([]);

  useEffect(() => {
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });
  return (
    <div className={`w-full`}>
      {/* button url */}
      <LabeledInput
        label={"Gomb url megadása:"}
        description={
          "Adjon meg gomb urlt. A gombra kattintással az itt megadott oldalra navigálhat."
        }>
        <TextInput
          type={"text"}
          name={"buttonUrl"}
          defaultValue={editableContent?.[0]?.content?.[0]?.buttonUrl ?? ""}
          ref={(r) => (inputRefs.current.buttonUrl = r)}
        />
      </LabeledInput>
      {/* button text */}
      <LabeledInput
        label={"Gomb szövegének megadása:"}
        description={"Adjon meg a gombon megjelenítendő szöveget."}>
        <TextInput
          type={"text"}
          name={"buttonText"}
          defaultValue={editableContent?.[0]?.content?.[0]?.buttonText ?? ""}
          ref={(r) => (inputRefs.current.buttonText = r)}
        />
      </LabeledInput>
      {/* button transform button text */}
      <LabeledInput
        label="Gomb szövegének nagybetűsség alakítása:"
        description="Válassza ki, hogy a gomb szövege normál vagy nagybetűssé alakított
            formában jelenjen meg. (alapértelmezett: Nagybetűssé alakítás)">
        <SelectInput
          name="transformTypes"
          options={initialData.bool}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.transformTypes
              ? initialData.bool.find(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]?.transformTypes
                )
              : initialData.bool[1]
          }
          placeholder="Gomb szövegének nagybetűsség alakítása"
          ref={(r) => (inputRefs.current.transformTypes = r)}
        />
      </LabeledInput>
      {/* button title */}
      <LabeledInput
        label={"Gomb címének (title) megadása:"}
        description={
          "Az itt megadott érték csak a keresőmotorok és a szövegolvasók számára látható."
        }>
        <TextInput
          type={"text"}
          name={"buttonTitle"}
          defaultValue={editableContent?.[0]?.content?.[0]?.buttonTitle ?? ""}
          ref={(r) => (inputRefs.current.buttonTitle = r)}
        />
      </LabeledInput>
      {/* button text alignment */}
      <LabeledInput
        label="Gomb szövegének rendezése:"
        description="Válassza ki, hogy a gomb szövege milyen elrendezésben jelenjen meg.
            (alapértelmezett: Középre zárt)">
        <SelectInput
          name="textAlignment"
          options={initialData.textAlignment}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.textAlignment
              ? initialData.textAlignment.find(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]?.textAlignment
                )
              : initialData.textAlignment[1]
          }
          placeholder="Gomb szövegének rendezése"
          ref={(r) => (inputRefs.current.textAlignment = r)}
        />
      </LabeledInput>
      {/* text padding */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"textPadding"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Szöveg eltartás: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy a szöveg elemnek mekkora eltartása legyen.
            Alapértelmezett: 0 0 0 0
          </span>
        </label>

        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
          <input
            type="text"
            name="textPaddingTop"
            id="textPaddingTop"
            ref={(r) => (inputRefs.current.textPaddingTop = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.textPaddingTop ?? 0
            }
          />
        </div>
        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.right}</span>
          <input
            type="text"
            name="textPaddingRight"
            id="textPaddingRight"
            ref={(r) => (inputRefs.current.textPaddingRight = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.textPaddingRight ?? 0
            }
          />
        </div>
        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.down}</span>
          <input
            type="text"
            name="textPaddingBottom"
            id="textPaddingBottom"
            ref={(r) => (inputRefs.current.textPaddingBottom = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.textPaddingBottom ?? 0
            }
          />
        </div>
        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.left}</span>
          <input
            type="text"
            name="textPaddingLeft"
            id="textPaddingLeft"
            ref={(r) => (inputRefs.current.textPaddingLeft = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.textPaddingLeft ?? 0
            }
          />
        </div>
      </div>
      {/* button border size */}
      <LabeledInput
        label={"Gomb keret vastagságának megadása:"}
        description={
          "Megadhatja, hogy milyen vastag legyen a gomb körüli keret. Az érték 0-50-ig állítható, pixelben számított érték. Alapértelmezett: 0"
        }>
        <TextInput
          type={"number"}
          name={"buttonBorderSize"}
          min={0}
          max={50}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.buttonBorderSize ?? ""
          }
          ref={(r) => (inputRefs.current.buttonBorderSize = r)}
          onChange={(e) => handleInputMinMax(e)}
        />
      </LabeledInput>
      {/* button border type */}
      <LabeledInput
        label="Gomb keret típusa:"
        description="Válassza ki, hogy a kép keretének milyen típusa legyen.
            Alapértelmezett: Solid">
        <SelectInput
          name="buttonBorderTypes"
          options={initialData.borderStyle}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.buttonBorderTypes
              ? initialData.borderStyle.find(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]?.buttonBorderTypes
                )
              : initialData.borderStyle[2]
          }
          placeholder="Gomb keret típusa"
          ref={(r) => (inputRefs.current.buttonBorderTypes = r)}
        />
      </LabeledInput>
      {/* button radius */}
      <LabeledInput
        label={"Gomb sarkainak kerekítése:"}
        description={
          "Az itt megadott érték határozza meg, hogy a gomb sarkai mennyire legyenek kerekítve. (0-100 közötti értéket adhat meg)"
        }>
        <TextInput
          type={"number"}
          name={"buttonRadius"}
          min={0}
          max={100}
          defaultValue={editableContent?.[0]?.content?.[0]?.buttonRadius ?? 0}
          ref={(r) => (inputRefs.current.buttonRadius = r)}
          onChange={(e) => handleInputMinMax(e)}
        />
      </LabeledInput>
      {/* button sizes */}
      <LabeledInput
        label="Gomb mérete:"
        description="Válassza ki, hogy a gomb milyen méretben jelenjen meg.
            (alapértelmezett: Normál)">
        <SelectInput
          name="buttonSizes"
          options={initialData.buttonSizes}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.buttonSizes
              ? initialData.buttonSizes.find(
                  (x) =>
                    x.value === editableContent?.[0]?.content?.[0]?.buttonSizes
                )
              : initialData.buttonSizes[1]
          }
          placeholder="Gomb mérete"
          ref={(r) => (inputRefs.current.buttonSizes = r)}
        />
      </LabeledInput>
      {/* button span */}
      <LabeledInput
        label="Gomb helykitöltése:"
        description="Válassza ki, hogy a gomb kitöltse-e a teljes rendelkezésre álló
            helyet. (alapértelmezett: Nem)">
        <SelectInput
          name="buttonSpan"
          options={initialData.bool}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.buttonSpan
              ? initialData.bool.find(
                  (x) =>
                    x.value === editableContent?.[0]?.content?.[0]?.buttonSpan
                )
              : initialData.bool[1]
          }
          placeholder="Gomb helykitöltése"
          ref={(r) => (inputRefs.current.buttonSpan = r)}
        />
      </LabeledInput>
    </div>
  );
};

export default ButtonSettings;
