import React, { useRef, useEffect } from "react";
import Image from "next/image";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import TextInput from "@/components/shared/textinput/TextInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import ApiCall from "@/api/api-calls";
import { initialData } from "@/data/data";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import { handleInputMinMax } from "@/utils/handleInputMinMax";
import ColorPicker from "react-best-gradient-color-picker";

const ButtonDesign = ({
  editableContent,
  color,
  setColor,
  backgroundColor,
  setBackgroundColor,
  buttonBorderColor,
  setButtonBorderColor,
  hoverColor,
  setHoverColor,
  backgroundHoverColor,
  setBackgroundHoverColor,
  buttonBorderHoverColor,
  setButtonBorderHoverColor,
  addRef,
}) => {
  const inputRefs = useRef([]);

  useEffect(() => {
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });
  return (
    <div className={`w-full`}>
      {/* button text color */}
      <LabeledInput
        label={"Betű szín:"}
        description={
          "Válassza ki, hogy milyen színű legyen a gomb elem szövege (alapértelmezett érték: #212121 - Fekete)."
        }>
        <ColorPickerComponent
          name={"buttonTextColor"}
          value={color}
          onChange={setColor}
        />
      </LabeledInput>
      {/* button background color */}
      <LabeledInput
        label={"Háttér szín:"}
        description={
          "Válassza ki, hogy milyen színű legyen a gomb elem háttere (alapértelmezett érték: #rgba(255, 255, 255, 1) - Fehér)."
        }>
        <ColorPickerComponent
          name={"buttonBackgroundColor"}
          value={backgroundColor}
          onChange={setBackgroundColor}
        />
      </LabeledInput>
      {/* button border color */}
      <LabeledInput
        label={"Gomb keret színének kiválasztása:"}
        description={
          "Megadhatja, hogy milyen színű legyen a kép körüli keret. Alapértelmezett: #212121"
        }>
        <ColorPickerComponent
          name={"buttonBorderColor"}
          value={buttonBorderColor}
          onChange={setButtonBorderColor}
        />
      </LabeledInput>
      {/* button hover text color */}
      <LabeledInput
        label={"Betű szín - hovernél:"}
        description={
          "Válassza ki, hogy milyen színű legyen a gomb elem szövege amikor fölévisszük az egeret (alapértelmezett érték: #fff - Fekete)."
        }>
        <ColorPickerComponent
          name={"buttonTextHoverColor"}
          value={hoverColor}
          onChange={setHoverColor}
        />
      </LabeledInput>
      {/* button hover background color */}
      <LabeledInput
        label={"Háttér szín - hovernél:"}
        description={
          "Válassza ki, hogy milyen színű legyen a gomb elem háttere amikor fölé viszi az egeret (alapértelmezett érték: #212121 - fekete)."
        }>
        <ColorPickerComponent
          name={"buttonHoverBackgroundColor"}
          value={backgroundHoverColor}
          onChange={setBackgroundHoverColor}
        />
      </LabeledInput>
      {/* button hover border color */}
      <LabeledInput
        label={"Kép keret hover színének kiválasztása:"}
        description={
          "Megadhatja, hogy milyen színű legyen a kép körüli keret, amikor fölé viszi az egeret. Alapértelmezett: #212121"
        }>
        <ColorPickerComponent
          name={"buttonBorderHoverColor"}
          value={buttonBorderHoverColor}
          onChange={setButtonBorderHoverColor}
        />
      </LabeledInput>
    </div>
  );
};

export default ButtonDesign;
