import React, { useRef, useState, useCallback, useEffect } from "react";
import ModalButton from "@/components/shared/modal/ModalButton";
import { useEditorButton } from "@/hooks/useEditorButton";
import TabSwitcher from "@/components/shared/tabswitcher/TabSwitcher";
import ButtonSettings from "./TabData/ButtonSettings";
import ButtonDesign from "./TabData/ButtonDesign";

const EditorButton = ({ toggleModal, modalName, type }) => {
  const { editableContent, handleSubmitEditorButton } = useEditorButton({
    toggleModal,
    modalName,
    type: type,
  });
  const [activeTab, setActiveTab] = useState(1);
  const handleTabClick = (tabNumber) => {
    setActiveTab(tabNumber);
  };

  useEffect(() => {
    if (editableContent) {
      setColor(
        editableContent?.[0]?.content?.[0]?.buttonTextColor ??
          "rgba(33, 33, 33, 1)"
      );
      setHoverColor(
        editableContent?.[0]?.content?.[0]?.buttonTextHoverColor ??
          "rgba(255, 255, 255, 1)"
      );
      setBackgroundColor(
        editableContent?.[0]?.content?.[0]?.buttonBackgroundColor ??
          "rgba(255, 255, 255, 1)"
      );
      setBackgroundHoverColor(
        editableContent?.[0]?.content?.[0]?.buttonHoverBackgroundColor ??
          "rgba(33, 33, 33, 1)"
      );
      setButtonBorderColor(
        editableContent?.[0]?.content?.[0]?.buttonBorderColor ??
          "rgba(255, 255, 255, 1)"
      );
      setButtonBorderHoverColor(
        editableContent?.[0]?.content?.[0]?.buttonBorderHoverColor ??
          "rgba(33, 33, 33, 1)"
      );
    }
  }, [editableContent]);
  const [color, setColor] = useState("");
  const [hoverColor, setHoverColor] = useState("");
  const [backgroundColor, setBackgroundColor] = useState("");
  const [backgroundHoverColor, setBackgroundHoverColor] = useState("");
  const [buttonBorderColor, setButtonBorderColor] = useState("");
  const [buttonBorderHoverColor, setButtonBorderHoverColor] = useState("");
  const inputRefs = useRef([]);

  const addRef = (key, ref) => {
    if (ref) {
      inputRefs.current[key] = ref; // Add or update the ref
    }
  };

  const submitEditorButton = useCallback(() => {
    handleSubmitEditorButton(
      {
        type: "button",
        title: "Gomb",
        buttonTextColor: color,
        buttonBackgroundColor: backgroundColor,
        buttonBorderColor: buttonBorderColor,
        buttonTextHoverColor: hoverColor,
        buttonHoverBackgroundColor: backgroundHoverColor,
        buttonBorderHoverColor: buttonBorderHoverColor,
      },
      inputRefs
    );
  }, [
    color,
    backgroundColor,
    buttonBorderColor,
    hoverColor,
    backgroundHoverColor,
    buttonBorderHoverColor,
    inputRefs,
    handleSubmitEditorButton,
  ]);

  const tabData = [
    { id: 1, tabTitle: "Gomb beállítások" },
    { id: 2, tabTitle: "Gomb design" },
  ];

  return (
    <div className="relative">
      {editableContent && (
        <div className="button-wrapper flex flex-col w-full p-4">
          <div className="w-full flex flex-row flex-nowrap border-b mb-4">
            <TabSwitcher
              data={tabData}
              activeTab={activeTab}
              onTabClick={handleTabClick}
            />
          </div>
          <div className={`w-full ${activeTab !== 1 ? "hidden" : ""}`}>
            <ButtonSettings editableContent={editableContent} addRef={addRef} />
          </div>
          <div className={`w-full ${activeTab !== 2 ? "hidden" : ""}`}>
            <ButtonDesign
              editableContent={editableContent}
              color={color}
              setColor={setColor}
              backgroundColor={backgroundColor}
              setBackgroundColor={setBackgroundColor}
              buttonBorderColor={buttonBorderColor}
              setButtonBorderColor={setButtonBorderColor}
              hoverColor={hoverColor}
              setHoverColor={setHoverColor}
              backgroundHoverColor={backgroundHoverColor}
              setBackgroundHoverColor={setBackgroundHoverColor}
              buttonBorderHoverColor={buttonBorderHoverColor}
              setButtonBorderHoverColor={setButtonBorderHoverColor}
              addRef={addRef}
            />
          </div>
        </div>
      )}

      <ModalButton btntext={"Mentés"} callback={submitEditorButton} />
    </div>
  );
};

export default EditorButton;
