import React, { useEffect, useState, useCallback, useRef } from "react";
import { initialData } from "@/data/data";
import Button from "@/components/shared/button/Button";
import ApiCall from "@/api/api-calls";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import { useEditorBlog } from "@/hooks/useEditorBlog";

const EditorBlog = ({ toggleModal, modalName }) => {
  const { editableContent, handleSubmitBlogData } = useEditorBlog({
    toggleModal,
    modalName,
  });
  const [isValid, setIsValid] = useState(false);
  const [columnData, setColumnData] = useState(null);
  const [color, setColor] = useState(
    editableContent?.[0]?.content?.[0]?.backgroundColor ??
      "rgba(255, 255, 255, 1)"
  );
  const inputRefs = useRef([]);

  useEffect(() => {
    const fetchColumnData = async () => {
      const articleColumns = await ApiCall.articleColumns.getSelect();
      setColumnData(articleColumns);
    };
    fetchColumnData();
  }, []);

  useEffect(() => {
    // If there is data, the form is valid
    setIsValid(editableContent?.[0]?.selectedColumn !== "" ? true : false);
  }, [editableContent]);

  const submitBlog = useCallback(() => {
    handleSubmitBlogData(
      {
        type: "blog",
        title: "Cikkek",
        backgroundColor: color,
      },
      inputRefs
    );
  }, [color, inputRefs]);

  return (
    <div className="relative">
      <div className="blog-wrapper flex flex-col w-auto p-4">
        {/* Layout display type */}
        <LabeledInput
          label="Layout elrendezés típusa:"
          description="Válassza ki, hogy milyen elrendezésben jelenjen(ek) meg a
              blogbejegyzés(ek) - (alapértelmezett érték: Hírek layout)">
          <SelectInput
            name="blogLayoutSelect"
            options={initialData.layoutDisplay}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.blogLayoutSelect
                ? initialData.layoutDisplay.find(
                    (x) =>
                      x.value ===
                      editableContent?.[0]?.content?.[0]?.blogLayoutSelect
                  )
                : initialData.layoutDisplay[2]
            }
            placeholder="Layout elrendezés típusa"
            ref={(r) => {
              inputRefs.current.blogLayoutSelect = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* blog layout select */}
        <LabeledInput
          label="Blog layout:"
          description="Válassza ki, hogy milyen formátumban jelenjen meg a blogbejegyzés
              - (alapértelmezett érték: Alap)">
          <SelectInput
            name="blogSelect"
            options={initialData.bloglayoutTypes}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.blogSelect
                ? initialData.bloglayoutTypes.find(
                    (x) =>
                      x.value === editableContent?.[0]?.content?.[0]?.blogSelect
                  )
                : initialData.bloglayoutTypes[2]
            }
            placeholder="Válasszon blog bejegyzés megjelenítést"
            ref={(r) => {
              inputRefs.current.blogSelect = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* blog post length */}
        <LabeledInput
          label="Bejegyzések száma oldalanként:"
          description="Válassza ki, hogy milyen formátumban jelenjen meg a blogbejegyzés
              - (alapértelmezett érték: Alap)">
          <SelectInput
            name="postsLength"
            options={initialData.postsLength}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.postsLength
                ? initialData.postsLength.find(
                    (x) =>
                      x.value ===
                      editableContent?.[0]?.content?.[0]?.postsLength
                  )
                : initialData.postsLength[3]
            }
            placeholder="Bejegyzések száma oldalanként"
            ref={(r) => {
              inputRefs.current.postsLength = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* infiniteLoad */}
        <LabeledInput
          label="Cikkek folyamatos töltése:"
          description="Válassza ki, hogy a kiválasztott cikkek folyamatosan
              töltődjenek-e, amíg el nem fogynak (alapértelmezett érték: Igen)">
          <SelectInput
            name="infiniteLoad"
            options={initialData.bool}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.infiniteLoad
                ? initialData.bool.find(
                    (x) =>
                      x.value ===
                      editableContent?.[0]?.content?.[0]?.infiniteLoad
                  )
                : initialData.bool[0]
            }
            placeholder="Cikkek folyamatos töltése"
            ref={(r) => {
              inputRefs.current.infiniteLoad = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* order posts by */}
        <LabeledInput
          label="Bejegyzések rendezése:"
          description="Válassza ki, hogy milyen érték alapján rendezve szeretné
              megjeleníteni a bejegyzéseket (alapértelmezett érték: Dátum)">
          <SelectInput
            name="orderBySelect"
            options={initialData.postsOrderBy}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.orderBySelect
                ? initialData.postsOrderBy.find(
                    (x) =>
                      x.value ===
                      editableContent?.[0]?.content?.[0]?.orderBySelect
                  )
                : initialData.postsOrderBy[0]
            }
            placeholder="Bejegyzések rendezése"
            ref={(r) => {
              inputRefs.current.orderBySelect = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* select post column */}
        {columnData && (
          <LabeledInput
            label="Megjelenítendő rovat kiválasztása:"
            description="Válassza ki, hogy rovatba tartozó bejegyzéseket kíván
                megjeleníteni">
            <SelectInput
              name="selectedColumn"
              options={columnData}
              defaultValue={
                editableContent?.[0]?.content?.[0]?.selectedColumn &&
                typeof editableContent?.[0]?.content?.[0]?.selectedColumn !==
                  "undefined"
                  ? columnData?.filter(
                      (x) =>
                        x.value ===
                        editableContent?.[0]?.content?.[0]?.selectedColumn
                    )
                  : columnData?.[0] || []
              }
              placeholder="Megjelenítendő rovat kiválasztása"
              ref={(r) => {
                inputRefs.current.selectedColumn = r;
                // addRef("imageLayers", r); // Explicitly add/update ref
              }}
              onChange={() => setIsValid(true)}
            />
          </LabeledInput>
        )}
        {/* show content display */}
        <LabeledInput
          label="Tartalom megjelenítése:"
          description=" Válassza ki, hogy a bejegyzésnél milyen hosszú szöveget szeretne
              megjeleníteni (alapértelmezett érték: Rövid szöveg)">
          <SelectInput
            name="orderBySelect"
            options={initialData.postContentLength}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.contentDisplay
                ? initialData.postContentLength.find(
                    (x) =>
                      x.value ===
                      editableContent?.[0]?.content?.[0]?.contentDisplay
                  )
                : initialData.postContentLength[0]
            }
            placeholder="Tartalom megjelenítése"
            ref={(r) => {
              inputRefs.current.contentDisplay = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* show date */}
        <LabeledInput
          label="Dátum megjelenítése:"
          description="Válassza ki, hogy a bejegyzéseknél szeretné e megjeleníteni a
              publikálás dátumát (alapértelmezett érték: Igen)">
          <SelectInput
            name="showDate"
            options={initialData.bool}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.showDate
                ? initialData.bool.find(
                    (x) =>
                      x.value === editableContent?.[0]?.content?.[0]?.showDate
                  )
                : initialData.bool[0]
            }
            placeholder="Dátum megjelenítése"
            ref={(r) => {
              inputRefs.current.showDate = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* show read more */}
        <LabeledInput
          label="Olvass tovább felirat megjelenítése:"
          description="Válassza ki, hogy a bejegyzéseknél szeretné e megjeleníteni az
              Olvass tovább... feliratot (alapértelmezett érték: Igen)">
          <SelectInput
            name="showReadMore"
            options={initialData.bool}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.showReadMore
                ? initialData.bool.find(
                    (x) =>
                      x.value ===
                      editableContent?.[0]?.content?.[0]?.showReadMore
                  )
                : initialData.bool[0]
            }
            placeholder="Olvass tovább felirat megjelenítése"
            ref={(r) => {
              inputRefs.current.showReadMore = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* show tags */}
        <LabeledInput
          label="Címkék megjelenítése:"
          description="Válassza ki, hogy a bejegyzéseknél szeretné e megjeleníteni a
              bejegyzéshez tartozó címkéket (alapértelmezett érték: Igen)">
          <SelectInput
            name="showTags"
            options={initialData.bool}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.showTags
                ? initialData.bool.find(
                    (x) =>
                      x.value === editableContent?.[0]?.content?.[0]?.showTags
                  )
                : initialData.bool[0]
            }
            placeholder="Címkék megjelenítése"
            ref={(r) => {
              inputRefs.current.showTags = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* blog background color */}
        <LabeledInput
          label={"Háttér szín:"}
          description={
            "Válassza ki, hogy milyen színűek legyenek az egyes blog elemek - (alapértelmezett érték: rgba(255, 255, 255, 1) - Fehér)."
          }>
          <ColorPickerComponent
            name={"backgroundColor"}
            value={color}
            onChange={setColor}
          />
        </LabeledInput>
      </div>
      <div className="flex flex-row w-auto justify-end sticky bottom-0 bg-white p-2 border border-t">
        <Button
          onClick={submitBlog}
          className="px-4 py-2 uppercase border bg-green-500/75 text-white hover:border-green-500 hover:bg-green-500 disabled:bg-gray-500 disabled:pointer-events-none"
          btntext="Mentés"
          disabled={!isValid}
        />
      </div>
    </div>
  );
};
export default EditorBlog;
