"use client";

import DocTemplateEditor from "./DocTemplateEditor";

export default function ExpandedDocTemplate({
  id,
  onSaved,
}: {
  id: string;
  onSaved?: () => void; // parent only cares that "something was saved"
}) {
  return (
    <div className="rounded border p-3 bg-white/50 space-y-3 max-w-[80vw]">
      <DocTemplateEditor
        id={id}
        onSaved={() => {
          // we *could* pass tpl up too, but list page doesn't need it
          onSaved?.();
        }}
      />
    </div>
  );
}
