// components/AdminChatFloatingWidget.jsx
"use client";

import { useContext, useState } from "react";
import AdminChat from "./AdminChat";
import { ChatUnreadContext } from "@/context/SocketProvider";

export default function AdminChatFloatingWidget() {
  const { unread } = useContext(ChatUnreadContext);
  const [open, setOpen] = useState(false);

  const toggle = () => setOpen((prev) => !prev);

  const hasUnread = typeof unread === "number" && unread > 0;

  return (
    <>
      {/* Floating button */}
      <button
        type="button"
        onClick={toggle}
        className="fixed bottom-4 right-4 z-40 inline-flex items-center justify-center w-11 h-11 rounded-full shadow-lg bg-indigo-600 text-white hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-400">
        <span className="material-icons text-[20px]">
          {open ? "close" : "chat"}
        </span>

        {/* 🔔 Always show badge if there is unread */}
        {hasUnread && (
          <span className="absolute -top-1 -right-1 inline-flex items-center justify-center min-w-[18px] h-[18px] rounded-full bg-red-600 text-[11px] font-semibold px-1">
            {unread > 9 ? "9+" : unread}
          </span>
        )}
      </button>

      {/* Chat panel */}
      <div
        className={`
          fixed bottom-20 right-4 z-40
          min-w-[340px] sm:min-w-[400px] md:min-w-[460px]
          transition-all duration-200
          ${
            open
              ? "opacity-100 translate-y-0 pointer-events-auto"
              : "opacity-0 translate-y-2 pointer-events-none"
          }
        `}>
        {/* AdminChat also has its own isOpen-based animation, that’s fine */}
        <AdminChat isOpen={open} />
      </div>
    </>
  );
}

// // components/AdminChatFloatingWidget.jsx
// "use client";

// import { useContext, useState } from "react";
// import AdminChat from "./AdminChat";
// import { ChatUnreadContext } from "@/context/SocketProvider";

// export default function AdminChatFloatingWidget() {
//   const { unread } = useContext(ChatUnreadContext);
//   const [open, setOpen] = useState(false);

//   const toggle = () => setOpen((prev) => !prev);

//   return (
//     <>
//       {/* Floating button */}
//       <button
//         type="button"
//         onClick={toggle}
//         className="fixed bottom-4 right-4 z-40 inline-flex items-center justify-center w-11 h-11 rounded-full shadow-lg bg-indigo-600 text-white hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-400">
//         <span className="material-icons text-[20px]">
//           {open ? "close" : "chat"}
//         </span>

//         {/* 🔔 Always show badge if there is unread */}
//         {unread > 0 && (
//           <span className="absolute -top-1 -right-1 inline-flex items-center justify-center min-w-[18px] h-[18px] rounded-full bg-red-600 text-[11px] font-semibold px-1">
//             {unread > 9 ? "9+" : unread}
//           </span>
//         )}
//       </button>

//       {/* Chat panel */}
//       <div
//         className={`fixed bottom-20 right-4 z-40 w-[320px] sm:w-[360px] md:w-[380px] ${
//           open ? "pointer-events-auto" : "pointer-events-none"
//         }`}>
//         <AdminChat isOpen={open} />
//       </div>
//     </>
//   );
// }
