// components/AuthListener.jsx
"use client";
import { useEffect } from "react";
import { useRouter } from "next/navigation";
import Cookies from "js-cookie";
import toast from "react-hot-toast";

const AuthListener = () => {
  const router = useRouter();

  useEffect(() => {
    const handleAuthFailed = () => {
      toast.error("A munkamenet lejárt. Kérlek jelentkezz be újra.");
      Cookies.remove("edSId"); // or any other token you use
      router.push("/"); // 🔁 your actual admin login route
    };

    window.addEventListener("auth-failed", handleAuthFailed);
    return () => {
      window.removeEventListener("auth-failed", handleAuthFailed);
    };
  }, [router]);

  return null;
};

export default AuthListener;
