import React from "react";

const checkboxConfig = [
  { id: "isDeleted", label: "Visszamondott rendelés:", color: "text-red-400" },
  { id: "isOuterStore", label: "Külső raktárról:", color: "text-blue-400" },
  {
    id: "isPacking",
    label: "Összekészítés folyamatban:",
    color: "text-gray-400",
  },
  { id: "isUnderDelivery", label: "Futárnak átadva:", color: "text-gray-400" },
  { id: "isCompleted", label: "Teljesítve:", color: "text-gray-400" },
];

const OrderStatusCheckboxGroup = ({ state, onChange }) => {
  return (
    <div className="w-full flex flex-row flex-wrap justify-evenly items-start">
      {checkboxConfig.map(({ id, label, color }) => (
        <div
          key={id}
          className="w-max flex flex-row flex-wrap justify-start items-center mb-4">
          <label
            htmlFor={id}
            className={`font-bold text-xs ${color} whitespace-pre flex-flex-col flex-wrap pr-2`}>
            {label}
          </label>
          <input
            type="checkbox"
            id={id}
            className="w-[1.5rem] h-[1.5rem]"
            checked={!!state[id]}
            onChange={() => onChange(id)}
          />
        </div>
      ))}
    </div>
  );
};

export default OrderStatusCheckboxGroup;
