import React from "react";
import { fetchWithAuth } from "@/lib/fetchUtils";
import { notFound } from "next/navigation";
import { cookies } from "next/headers";
import UserListComponent from "./ListComponent";

const UsersPage = async () => {
  const cookieStore = await cookies();
  const token = cookieStore.get("token")?.value;

  const query = `?page=1&pageSize=25&sortField=createdAt&sortDirection=desc`;

  try {
    const response = await fetchWithAuth(`/api/admin/users/list`, query, {
      next: {
        revalidate: 0,
        tags: [`users`],
      },
    });
    const tableData = response?.tableData || [];
    const totalRecords = response?.totalRecords || 0;

    return (
      <UserListComponent
        tableData={tableData}
        totalRecords={totalRecords}
        token={token}
      />
    );
  } catch (error) {
    console.error("SSR error in UsersPage:", error);
    return <div>Hiba történt az adatok betöltésekor.</div>;
  }
};

export default UsersPage;
