"use client";

import { useEffect, useState } from "react";
import toast from "react-hot-toast";
import ApiCall from "@/api/api-calls";

import ExpandedRowTabs from "@/components/filing/ExpandedRowTabs";
import FilingProperties from "@/components/filing/FilingProperties";
import FilingDocumentTab from "@/components/filing/FilingDocumentTab";

const CreateFiling = () => {
  const [activeTab, setActiveTab] = useState(1);
  const [ownCompanies, setOwnCompanies] = useState([]);
  const [partnerCompanies, setPartnerCompanies] = useState([]);
  const [currencies, setCurrencies] = useState([]);
  const [filingId, setFilingId] = useState(null);
  const [documentTypes, setDocumentTypes] = useState([]);

  useEffect(() => {
    const fetchInitialData = async () => {
      try {
        const [res, curr, types] = await Promise.all([
          ApiCall.filing.getCreate(),
          ApiCall.currency.getAll(),
          ApiCall.documents.getDocumentTypes(),
        ]);
        if (curr.status === 200) setCurrencies(curr.data.currencies);
        if (res.status === 200) {
          setOwnCompanies(res.data.references.ownCompanies);
          setPartnerCompanies(res.data.references.partnerCompanies);
        }
        if (types.status === 200) {
          setDocumentTypes(types.data);
        }
      } catch {
        toast.error("Hiba az adatok betöltésekor");
      }
    };
    fetchInitialData();
  }, []);

  const getDocTypeId = (typeValue) =>
    documentTypes.find((dt) => dt.value === typeValue)?.id || null;

  return (
    <div className="p-6 max-w-4xl mx-auto">
      <ExpandedRowTabs activeTab={activeTab} onTabChange={setActiveTab} />

      <div className={activeTab === 1 ? "block" : "hidden"}>
        <FilingProperties
          ownCompanies={ownCompanies}
          partnerCompanies={partnerCompanies}
          currencies={currencies}
          onCreateSuccess={(createdId) => setFilingId(createdId)}
        />
      </div>

      <div className={activeTab === 2 ? "block" : "hidden"}>
        {!filingId ? (
          <p className="text-red-500">Előbb mentse el az iratot!</p>
        ) : (
          <FilingDocumentTab
            filingId={filingId}
            description="Díjbekérő"
            tabLabel="Díjbekérők"
            documentTypeIds={[
              getDocTypeId("díjbekérő"),
              getDocTypeId("előlegszámla"),
            ].filter(Boolean)}
            defaultDocumentTypeId={getDocTypeId("díjbekérő")}
          />
        )}
      </div>

      <div className={activeTab === 3 ? "block" : "hidden"}>
        {!filingId ? (
          <p className="text-red-500">Előbb mentse el az iratot!</p>
        ) : (
          <FilingDocumentTab
            filingId={filingId}
            description="Számla"
            tabLabel="Számlák"
            documentTypeIds={[getDocTypeId("invoice")].filter(Boolean)}
            defaultDocumentTypeId={getDocTypeId("invoice")}
          />
        )}
      </div>

      <div className={activeTab === 4 ? "block" : "hidden"}>
        {!filingId ? (
          <p className="text-red-500">Előbb mentse el az iratot!</p>
        ) : (
          <FilingDocumentTab
            filingId={filingId}
            description="Végszámla"
            tabLabel="Végszámla"
            documentTypeIds={[getDocTypeId("végszámla")].filter(Boolean)}
            defaultDocumentTypeId={getDocTypeId("végszámla")}
          />
        )}
      </div>
    </div>
  );
};

export default CreateFiling;

// "use client";

// import { useEffect, useState } from "react";
// import toast from "react-hot-toast";
// import ApiCall from "@/api/api-calls";

// import ExpandedRowTabs from "@/components/filing/ExpandedRowTabs";
// import FilingProperties from "@/components/filing/FilingProperties";
// import FilingDocumentTab from "@/components/filing/FilingDocumentTab";

// const CreateFiling = () => {
//   const [activeTab, setActiveTab] = useState(1);
//   const [ownCompanies, setOwnCompanies] = useState([]);
//   const [partnerCompanies, setPartnerCompanies] = useState([]);
//   const [currencies, setCurrencies] = useState([]);
//   const [filingId, setFilingId] = useState(null);
//   const [documentTypes, setDocumentTypes] = useState([]); // 🔑 Add state
//   console.log("types", documentTypes);
//   useEffect(() => {
//     const fetchInitialData = async () => {
//       try {
//         const [res, curr, types] = await Promise.all([
//           ApiCall.filing.getCreate(),
//           ApiCall.currency.getAll(),
//           ApiCall.documents.getDocumentTypes(), // 🔑 Fetch document types
//         ]);
//         if (curr.status === 200) setCurrencies(curr.data.currencies);
//         if (res.status === 200) {
//           setOwnCompanies(res.data.references.ownCompanies);
//           setPartnerCompanies(res.data.references.partnerCompanies);
//         }
//         if (types.status === 200) {
//           setDocumentTypes(types.data);
//         }
//       } catch (err) {
//         toast.error("Hiba az adatok betöltésekor");
//       }
//     };
//     fetchInitialData();
//   }, []);

//   // Helpers to find document type IDs by some label or static mapping
//   const getDocTypeId = (typeName) =>
//     documentTypes.find((dt) => dt.value === typeName)?.id || null;

//   return (
//     <div className="p-6 max-w-4xl mx-auto">
//       <ExpandedRowTabs activeTab={activeTab} onTabChange={setActiveTab} />

//       <div className={activeTab === 1 ? "block" : "hidden"}>
//         <FilingProperties
//           ownCompanies={ownCompanies}
//           partnerCompanies={partnerCompanies}
//           currencies={currencies}
//           onCreateSuccess={(createdId) => setFilingId(createdId)}
//         />
//       </div>

//       <div className={activeTab === 2 ? "block" : "hidden"}>
//         {!filingId ? (
//           <p className="text-red-500">Előbb mentse el az iratot!</p>
//         ) : (
//           <FilingDocumentTab
//             filingId={filingId}
//             description="Díjbekérő"
//             tabLabel="Díjbekérők"
//             documentTypeId={
//               getDocTypeId("díjbekérő") || getDocTypeId("előlegszámla")
//             } // ← pass the specific type
//           />
//         )}
//       </div>

//       <div className={activeTab === 3 ? "block" : "hidden"}>
//         {!filingId ? (
//           <p className="text-red-500">Előbb mentse el az iratot!</p>
//         ) : (
//           <FilingDocumentTab
//             filingId={filingId}
//             description="Számla"
//             tabLabel="Számlák"
//             documentTypeId={getDocTypeId("invoice")}
//           />
//         )}
//       </div>

//       <div className={activeTab === 4 ? "block" : "hidden"}>
//         {!filingId ? (
//           <p className="text-red-500">Előbb mentse el az iratot!</p>
//         ) : (
//           <FilingDocumentTab
//             filingId={filingId}
//             description="Végszámla"
//             tabLabel="Végszámla"
//             documentTypeId={getDocTypeId("végszámla")}
//           />
//         )}
//       </div>
//     </div>
//   );
// };

// export default CreateFiling;
