"use client";

import { useRouter } from "next/navigation";
import toast from "react-hot-toast";
import ApiCall from "@/api/api-calls";
import RegistrarForm from "@/components/domain-registrars/RegistrarForm";

export default function RegistrarCreatePage() {
  const router = useRouter();

  const handleCreate = async (payload: {
    name: string;
    email?: string | null;
    url?: string | null;
    password?: string | null;
  }) => {
    try {
      const res = await ApiCall.domainRegistrar.create(payload);
      if (res?.status === 201) {
        toast.success("Létrehozva");
        router.push("/admin/domain-registrars/list");
      } else {
        toast.error(res?.data?.error ?? "Sikertelen létrehozás");
      }
    } catch (e: any) {
      const msg = e?.response?.data?.error ?? "Sikertelen létrehozás";
      toast.error(msg);
    }
  };

  return (
    <main className="p-4 space-y-4 max-w-2xl">
      <h1 className="text-xl font-semibold">Új regisztrátor</h1>
      <RegistrarForm onSubmit={handleCreate} />
    </main>
  );
}
