"use client";

import { useRouter } from "next/navigation";
import toast from "react-hot-toast";
import ApiCall from "@/api/api-calls";
import DocTemplateKindForm, {
  DocTemplateKindPayload,
} from "@/components/document-template-kinds/DocTemplateKindForm";

export default function CreateDocTemplateKindPage() {
  const router = useRouter();

  const handleSubmit = async (payload: DocTemplateKindPayload) => {
    try {
      const res = await ApiCall.docTemplateKinds.upsertItem(payload);
      toast.success("Sablon típus létrehozva");
      const created = res.data;
      router.push(`/admin/document-template-kinds/list`); // or `/admin/doc-template-kinds/${created.id}`
    } catch (e: any) {
      console.error(e);
      toast.error(
        e?.response?.data?.error ?? "Sablon típus mentése sikertelen"
      );
    }
  };

  return (
    <main className="p-4 space-y-4 max-w-3xl mx-auto">
      <div className="flex items-center justify-between">
        <h1 className="text-lg font-semibold">Új sablon típus</h1>
        <button
          onClick={() => router.push("/admin/document-template-kinds/list")}
          className="px-3 py-2 text-sm rounded border border-gray-300 hover:bg-gray-50">
          Vissza a listához
        </button>
      </div>

      <DocTemplateKindForm onSubmit={handleSubmit} />
    </main>
  );
}
